/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.RelationTuple;

public class DefaultRelationTuple
implements RelationTuple {
    private Map<String, Object> tuple;

    public DefaultRelationTuple(Map<String, Object> t) {
        this.tuple = new LinkedHashMap<String, Object>(t);
    }

    @Override
    public Object get(String name) throws SQLException {
        if (!this.tuple.containsKey(name)) {
            throw ErrorBundle.getDefault(10009, name);
        }
        return this.tuple.get(name);
    }

    @Override
    public RelationTuple copy() {
        return new DefaultRelationTuple(this.tuple);
    }

    @Override
    public Map<String, Object> toMap() throws SQLException {
        return Collections.unmodifiableMap(this.tuple);
    }

    public int hashCode() {
        return this.tuple.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof DefaultRelationTuple && this.tuple.equals(((DefaultRelationTuple)o).tuple);
    }

    public String toString() {
        return this.tuple.toString();
    }
}

