/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.morilib.db.relations.AbstractRelation;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public class SingleTableRelation
extends AbstractRelation
implements NamedRelation {
    private SqlCreateTable table;
    private Collection<RelationTuple> data;
    private String name;

    public SingleTableRelation(SqlCreateTable t, String name, Collection<RelationTuple> data) {
        this.table = t;
        this.data = data;
        this.name = name != null ? name : t.getName();
    }

    @Override
    public List<SqlColumnDefinition> getColumnNames() {
        return new ArrayList<SqlColumnDefinition>(this.table.getColumnDefinitions());
    }

    @Override
    public RelationCursor iterator() {
        final Iterator<RelationTuple> i = this.data.iterator();
        return new RelationCursor(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public RelationTuple next() {
                return (RelationTuple)i.next();
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SqlColumnDefinition getDefinition(String name) {
        for (SqlColumnDefinition d : this.table.getColumnDefinitions()) {
            if (!name.equals(d.getName())) continue;
            return d;
        }
        return null;
    }
}

