/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;

import net.morilib.db.delay.Delay;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;

public class FnCoalesce extends RelationFunction {

	private static Object nvlx(Object... args) {
		for(Object o : args) {
			if(!RelationExpression.isNull(o)) {
				return o;
			}
		}
		return RelationExpression.NULL;
	}

	@Override
	public boolean isAggregate() {
		return false;
	}

	@Override
	public Object operate(RelationAggregate m, List<Object> group,
			final Object... args) throws SQLException {
		boolean f = false;

		for(Object o : args)  f = f || o instanceof Delay;
		if(f) {
			Delay d = new Delay() {

				@Override
				public Object force() throws SQLException {
					Object[] q = new Object[args.length];

					for(int i = 0; i < q.length; i++) {
						q[i] = args[i] instanceof Delay ?
								((Delay)args[i]).force() : args[i];
					}
					return nvlx(q);
				}

				@Override
				public void add(Object... o) throws SQLException {
					for(Object x : args) {
						if(x instanceof Delay) {
							((Delay)x).add(o);
						}
					}
				}

			};

			m.put(group, d);
			return d;
		} else {
			return nvlx(args);
		}
	}

	@Override
	public Object init() throws SQLException {
		return Rational.ZERO;
	}

	@Override
	public FunctionType getType() {
		return FunctionType.STRING;
	}

}
