/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.functions;

import java.util.HashMap;
import java.util.Map;

import net.morilib.db.expr.RelationFunction;

public final class FunctionLoader {

	private FunctionLoader() {}

	public static Map<String, RelationFunction> load() {
		HashMap<String, RelationFunction> map;

		map = new HashMap<String, RelationFunction>();
		map.put("COALESCE", new FnCoalesce());
		map.put("ROUND", new FnRound());
		map.put("TRIM", new FnTrim());

		map.put("AVG", new FnAvg());
		map.put("CORR", new FnCorr());
		map.put("COUNT", new FnCount());
		map.put("COV", new FnCov());
		map.put("DEV", new FnDev());
		map.put("DEVUNBIASED", new FnDevUnbiased());
		map.put("KURT", new FnKurt());
		map.put("MAX", new FnMax());
		map.put("MEDIAN", new FnMedian());
		map.put("MIN", new FnMin());
		map.put("SKEW", new FnSkew());
		map.put("SUM", new FnSum());
		map.put("VAR", new FnVar());
		map.put("VARUNBIASED", new FnVarUnbiased());
		return map;
	}

}
