/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.gui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.table.AbstractTableModel;

import net.morilib.db.misc.Rational;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class RelationQueryTableModel extends AbstractTableModel {

	private List<SqlColumnDefinition> head;
	private List<RelationTuple> list;

	/**
	 * 
	 * @param r
	 * @throws IOException
	 * @throws SQLException
	 */
	public RelationQueryTableModel(
			Relation r) throws IOException, SQLException {
		RelationCursor c;

		head = r.getColumnNames();
		list = new ArrayList<RelationTuple>();
		c = r.iterator();
		while(c.hasNext())  list.add(c.next());
	}

	@Override
	public int getRowCount() {
		return list.size();
	}

	@Override
	public int getColumnCount() {
		return head.size();
	}

	@Override
	public String getColumnName(int columnIndex) {
		return head.get(columnIndex).getName();
	}

	@Override
	public Class<?> getColumnClass(int columnIndex) {
		return head.get(columnIndex).getName().getClass();
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return false;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		Iterator<Map.Entry<String, Object>> itr;
		Object o;

		try {
			Map<String, Object> m = list.get(rowIndex).toMap();

			itr = m.entrySet().iterator();
			for(int i = 0; i < columnIndex; i++, itr.next());
			o = itr.next().getValue();
			if(o instanceof Rational) {
				return ((Rational)o).toBigDecimal(4).stripTrailingZeros();
			} else {
				return o;
			}
		} catch (SQLException e) {
			return "(fail to get)";
		}
	}

	@Override
	public void setValueAt(Object aValue, int rowIndex,
			int columnIndex) {
		// do nothing
	}

}
