/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlInsertValues implements SqlDml {

	private List<String> columns;
	private List<SqlExpression> exprs;
	private String name;

	public SqlInsertValues(String n, List<String> c,
			List<SqlExpression> e) {
		name = n;
		columns = new ArrayList<String>(c);
		exprs = new ArrayList<SqlExpression>(e);
	}

	public String getName() {
		return name;
	}

	public List<String> getColumns() {
		return Collections.unmodifiableList(columns);
	}

	public List<SqlExpression> getExprs() {
		return Collections.unmodifiableList(exprs);
	}

	@Override
	public int getMaxParameter() {
		int j = 0;

		for(SqlExpression e : exprs) {
			j = Math.max(j, e.getMaxParameter());
		}
		return j;
	}

}
