/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.ddl;

import java.sql.SQLException;

public abstract class SqlColumnType {

	/**
	 * 
	 * @param s
	 * @return
	 * @throws SQLException
	 */
	public abstract Object cast(String s) throws SQLException;

	/**
	 * 
	 * @param o
	 * @return
	 */
	public abstract String string(Object o) throws SQLException;

	/**
	 * 
	 * @return
	 */
	public abstract int getLength();

	/**
	 * 
	 * @return
	 */
	public abstract int getScale();

	/**
	 * 
	 * @return
	 */
	public abstract int getSqlType();

	/**
	 * 
	 * @return
	 */
	public abstract Class<?> getTypeClass();

}
