/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.httpd;

import java.io.IOException;
import java.io.InputStream;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/28
 */
public class URLEncodedInputStream extends InputStream {

	private static enum S { INI, P01, P02 }

	private S etat = S.INI;
	private InputStream ins;

	/**
	 * 
	 * @param ins
	 */
	public URLEncodedInputStream() {
		this.ins = null;
	}

	/**
	 * 
	 * @param ins
	 * @throws IOException
	 */
	public void newInputStream(InputStream ins) throws IOException {
		if(this.ins != null)  this.ins.close();
		this.ins = ins;
	}

	@Override
	public int read() throws IOException {
		int c, r = 0;

		if(ins == null)  throw new IllegalStateException();
		while(true) {
			c = ins.read();
			switch(etat) {
			case INI:
				if(c < 0) {
					return -1;
				} else if(c == '+') {
					return ' ';
				} else if(c == '%') {
					etat = S.P01;  r = 0;
					break;
				} else {
					return c;
				}
			case P01:
				if(c >= '0' && c <= '9') {
					etat = S.P02;  r = c - '0';
					break;
				} else {
					return '%';
				}
			case P02:
				if(c >= '0' && c <= '9') {
					return r * 10 + (c - '0');
				} else {
					return '%';
				}
			}
		}
	}

	@Override
	public void close() throws IOException {
		ins.close();
	}

}
