// -*- Mode: java -*-
//Header:
//File: CellBase.java
//Author: NODA, Itsuki
//Date: 2002/01/13
//Copyright (C) 2002 by Itsuki NODA, AIST
//EndHeader:

import Side ;
import BoardBase ;

//============================================================
// class CellBase

public class CellBase {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // state
	
    public Side state ;

    public boolean isBlack() { return state.isBlack() ; } ;
    public boolean isWhite() { return state.isWhite() ; } ;
    public boolean isEmpty() { return state.isNone() ; } ;
    public boolean isSame(Side side) { return state.isSame(side) ; } ;
    public boolean isOther(Side side) { return !state.isSame(side) ; } ;

    public boolean isPassable(Side side) {
	return isSame(side) || isEmpty() ;
    } ;

    public boolean isStoppable(Side side) {
	return isOther(side) || isEmpty() ;
    } ;

    public void turnBlack() { state = Side.black ; } ;
    public void turnWhite() { state = Side.white ; } ;
    public void turnEmpty() { state = Side.none ; } ;
    public void turnSame(Side side) { state = side ; } ;

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // board & position
	
    BoardBase board ;
    int x ;
    int y ;

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // mark

    boolean mark_ ;

    public void mark() { mark_ = true ; } ;
    public void unmark() { mark_ = false ; } ;
	
    public boolean isMarked() { return mark_ ; } ;
	
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // movable flag

    boolean movable ;

    public void setMovable() { movable = true ; } ;
    public void unsetMovable() { movable = false ; } ;

    public boolean isMovable() { return movable ; } ;

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // check flag

    public boolean check ;

    //----------------------------------------
    // init

    public CellBase() {} ;
    

    public CellBase(BoardBase b, int i, int j) { init(b,i,j) ; } ;

    public void init(BoardBase b, int i, int j) {
	board = b ;
	x = i ;
	y = j ;
	clear() ;
    } ;

    //----------------------------------------
    // clear
	
    public void clear() {
	turnEmpty() ;
	unmark() ;
	unsetMovable() ;
    } ;

    //----------------------------------------
    // toString
	
    public String toString() {
	return "cell(" + x + "," + y + "|" + state + ")" ;
    } ;

    //============================================================
    // class Factory

    public static class Factory {
	public CellBase newCell() { return new CellBase() ; } ;
	public CellBase newCell(BoardBase b, int i, int j) {
	    return new CellBase(b,i,j) ;
	} ;
    } ;

    public static Factory factory = new Factory() ;
	
} ;


