// -*- Mode: java -*-
//Header:
//File: ClientBoard.java
//Author: NODA, Itsuki
//Date: 2002/01/15
//Copyright (C) 2002 by Itsuki NODA, AIST
//EndHeader:

import java.io.* ;
import java.net.* ;
import java.awt.* ;
import javax.swing.* ;
import java.awt.event.* ;
import java.util.* ;

import Side ;
import CellBase ;
import SynchronizedBoard ;
import Sexp ;

//============================================================
// ClientBoard

public class ClientBoard extends SynchronizedBoard {

    //========================================
    // class Socket Thread

    class SocketThread extends Thread {

	public String host ; 
	public int port ; 

	public ClientBoard board ;

	public Socket socket ;

	public Reader reader ; 
	public Writer writer ; 

	public SocketThread(ClientBoard b) { init(b) ; } ;

	public void init(ClientBoard b) {
	    board = b ; 
	    host = b.host ;
	    port = b.port ;
	} ;

	public void run() {
	    try {
		socket = new Socket(host,port) ;
		reader = new InputStreamReader(socket.getInputStream()) ;
		writer = new OutputStreamWriter(socket.getOutputStream()) ;

		while(true) {
		    cycle() ;
		}
	    } catch (Exception ex) { 
		System.err.println("Error:" + ex.getMessage()) ;
		return ;
	    }
	} ;

	public void cycle() {
	    try {
		char buf[] = new char[1024] ;
		reader.read(buf) ;
		
		String str = new String(buf) ;

		Sexp s = Sexp.factory().scan(str) ;
		
		System.out.println(s.toString()) ;
		
		if(s.equals(Sexp.Eof)) {
		    throw new Exception("EOF is deteced.") ;
		}

		if(s.isCons() && s.car().equals("ok")) { return ; }
		if(s.isCons() && s.car().equals("error")) { return ; }

		board.execSexpCommand(s) ;
		

	    } catch (Exception ex) { 
		System.err.println("Error:" + ex.getMessage()) ;
		return ;
	    }
	} ;
    } ;

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // socket thread

    public SocketThread socketThread ;

    static final String defaultHost = "localhost" ;
    static final int defaultPort = 16000 ;

    public String host ;
    public int port ;

    //--------------------------------------------------
    // constructor

    public ClientBoard() { init(defaultHost, defaultPort) ; } ;
    public ClientBoard(String h, int p) { init(h,p) ; } ;

    public void init(String h, int p) {
	host = h ;
	port = p ;
	
	socketThread = new SocketThread(this) ;
	socketThread.start() ;
    } ;

    //--------------------------------------------------
    // move

    public boolean move(int fx, int fy, int tx, int ty, boolean checksidep) {

	Side currentside = nextSide ;
	Side side = myside ;

	try {
	    if (myside == nextSide || myside == Side.none) {
		socketThread.writer.write(moveString(side,fx,fy,tx,ty,false)) ;
		socketThread.writer.flush() ;
	    } ;
	} catch (Exception ex) { 
	    System.err.println("Error:" + ex.getMessage()) ;
	    return false ;
	}

	return true ;
    } ;

    //--------------------------------------------------
    // quit

    public void quit(boolean directp) {
	if(directp) {
	    try {
		Sexp quitSexp = Sexp.factory().list("quit") ;
		String quitstr = quitSexp.toString() ;

		socketThread.writer.write(quitstr) ;
		socketThread.writer.flush() ;
	    } catch (Exception ex) { 
		System.err.println("Error:" + ex.getMessage()) ;
	    }
	}
	super.quit(directp) ;
    } ;
} ;
