// -*- Mode: java -*-
//Header:
//File: LOA.java
//Author: NODA, Itsuki
//Date: 2002/01/14
//Copyright (C) 2002 by Itsuki NODA, AIST
//EndHeader:

import SynchronizedBoard ;
import NetBoard ;
import BoardWindow ;
import ServerBoard ;
import ClientBoard ;

//======================================================================
// class LOA

public class LOA {

    //============================================================
    // main
    
    public static void main(String argv[]) {
	run(argv) ;
    }

    //----------------------------------------
    // run

    public static void run(String argv[]) {
	
	Side side = Side.none ;

	boolean networkp = false ;
	boolean serverp = false ;
	String shost = "localhost";
	int sport = NetBoard.SocketThread.defaultPort ;

	for(int i = 0 ; i < argv.length ; i++) {
	    if      (argv[i].equals("-standalone")) {
		networkp = false ;
	    }
	    else if (argv[i].equals("-server")) {
		networkp = true ;
		serverp = true ;
		side = Side.black ;
	    } 
	    else if (argv[i].equals("-client")) {
		networkp = true ;
		serverp = false ;
		i++ ;
		shost = argv[i] ;
		side = Side.white ;
	    } 
	} 

	if(networkp) {
	    if(serverp) {
		runServer(sport) ;
	    } else {
		runClient(shost,sport) ;
	    }
	} else {
	    runStandAlone(sport) ;
	}
    } ;

    //----------------------------------------
    // stand alone

    public static void runStandAlone(int sport) {
	ServerBoard s = new ServerBoard() ;
	s.publicModep = true ;
	SynchronizedBoard b = new ClientBoard("localhost", sport) ;
	
	BoardWindow w = new BoardWindow(b) ;
    } ;

    //----------------------------------------
    // server

    public static void runServer(int sport) {
	SynchronizedBoard s = new ServerBoard() ;
	SynchronizedBoard b = new ClientBoard("localhost", sport) ;

	BoardWindow w = new BoardWindow(b) ;
    } ;

    //----------------------------------------
    // client

    public static void runClient(String shost, int sport) {
	SynchronizedBoard b = new ClientBoard(shost, sport) ;

	BoardWindow w = new BoardWindow(b) ;
    } ;

} ;
