// -*- Mode: java -*-
//Header:
//File: NetBoard.java
//Author: NODA, Itsuki
//Date: 2002/01/10
//Copyright (C) 2002 by Itsuki NODA, AIST
//EndHeader:

import java.io.* ;
import java.net.* ;
import java.awt.* ;
import javax.swing.* ;
import java.awt.event.* ;
import java.util.* ;

import Side ;
import CellBase ;
import SynchronizedBoard ;
import Sexp ;



//============================================================
// socket

public class NetBoard extends SynchronizedBoard {

    //========================================
    // class Socket Thread

    class SocketThread extends Thread {

	static final int defaultPort = 16000 ;

	public NetBoard board ;

	public ServerSocket server ; 
	public Socket socket ;

	public Reader reader ; 
	public Writer writer ; 

	public boolean serverp ;

	public String shost ;
	public int sport ;

	public SocketThread(NetBoard b) {
	    board = b ; 
	} ;

	public void run() {
	    if(serverp) {
		initServerSocket() ;
	    } else {
		initSocket() ;
	    }
	} ;

	public boolean initServerSocket() {
	    try { server = new ServerSocket(sport) ; } 
	    catch (java.lang.Exception ex) { 
		System.err.println("Error:" + ex.getMessage()) ;
		return false ; 
	    }

	    runServerSocket() ;
	    return true ;
	} ;

	public void runServerSocket() {
	    try { socket = server.accept() ; }
	    catch (java.lang.Exception ex) {
		System.err.println("Error:" + ex.getMessage()) ;
	    } 
	    
	    runSocket() ;
	} ;

	public boolean initSocket(String host, int port) {
	    shost = host ;
	    sport = port ;
	    initSocket() ;
	    return true ;
	} ;

	public boolean initSocket() {
	    
	    try { socket = new Socket(shost,sport) ; } 
	    catch (java.lang.Exception ex) { 
		System.err.println("Error:" + ex.getMessage()) ;
		return false ; }
	    
	    runSocket() ;

	    return true ;
	} ;
	
	public void runSocket() {
	    try {
		reader = new InputStreamReader(socket.getInputStream()) ;
		writer = new OutputStreamWriter(socket.getOutputStream()) ;
	    } catch (java.lang.Exception ex) { 
		System.err.println("Error:" + ex.getMessage()) ;
	    } ;

	    while(true) {
		cycleSocket() ;
	    }
	} ;

	public void cycleSocket() {
	    try { 
		char buf[] = new char[1024] ;
		reader.read(buf) ;

		String str = new String(buf) ;

		Sexp s = Sexp.factory().scan(str) ;

		if(s.equals(Sexp.Eof)) 
		    throw new Exception("EOF is detected.") ;

		boolean successp = board.execSexpCommand(s) ;

	    } catch (java.lang.Exception ex) { 
		System.err.println("Error:" + ex.getMessage()) ;
	    }
	} ;

    } ;

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // socket

    public SocketThread socketThread ;

    public void runServer() {
	runServer(SocketThread.defaultPort) ;
    } ;
    public void runServer(int port) {
	socketThread = new SocketThread(this) ;
	socketThread.serverp = true ;
	socketThread.sport = port ;
	socketThread.start() ;
    } ;

    public void runClient(String shost) {
	runClient(shost,SocketThread.defaultPort) ;
    } ;
    public void runClient(String shost, int port) {
	socketThread = new SocketThread(this) ;
	socketThread.serverp = false ;
	socketThread.shost = shost ;
	socketThread.sport = port ;
	
	socketThread.start() ;
    } ;

    //------------------------------------------------------------
    // constructor

    public NetBoard() { init(Side.none) ; } ;
    public NetBoard(Side side) { init(side) ; } ;

    public NetBoard(int port) { // run as server
	init(port) ;
    } ;

    public NetBoard(String shost, int port) { // run as client
	init(shost,port) ;
    } ;

    public void init() { init(Side.none) ; } ;

    public void init(Side side) { 
	super.init(side) ; 
	loggingOn(System.out) ;
    } ;

    public void init(int port) { // run as server
	init(Side.black) ;
	runServer(port) ;
    } ;

    public void init(String shost, int port) { // run as client
	init(Side.white) ;
	runClient(shost,port) ;
    } ;

    //------------------------------------------------------------
    // move

    public boolean move(int fx, int fy, int tx, int ty, boolean checksidep) {

	Side currentside = nextSide ;
	Side side = myside ;

	super.move(fx,fy,tx,ty,checksidep) ;

	if(currentside == myside) {
	    try {
		socketThread.writer.write(lastlog.toString()) ;
		socketThread.writer.flush() ;
	    } catch (java.lang.Exception ex) { 
		System.err.println("Error:" + ex.getMessage()) ;
	    }
	}

	return true ;
    } ;

} ;

