// -*- Mode: java -*-
//Header:
//File: Side.java
//Author: NODA, Itsuki
//Date: 2002/01/13
//Copyright (C) 2002 by Itsuki NODA, AIST
//EndHeader:

import Sexp ;

//============================================================
// class Side

public class Side {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // constant int values

    public static final int none_ = 0 ;
    public static final int white_ = 1 ;
    public static final int black_ = -1 ;
    public static final int error_ = -2 ;

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // constant string values

    public static final String noneStr_ = "none" ;
    public static final String whiteStr_ = "white" ;
    public static final String blackStr_ = "black" ;
    public static final String errorStr_ = "error" ;

    public static final String noneChar_  = "n" ;
    public static final String whiteChar_ = "W" ;
    public static final String blackChar_ = "B" ;
    public static final String errorChar_ = "e" ;

    public static final Sexp noneCharSexp = 
	Sexp.factory().newSymbol(noneChar_) ;
    public static final Sexp whiteCharSexp = 
	Sexp.factory().newSymbol(whiteChar_) ;
    public static final Sexp blackCharSexp = 
	Sexp.factory().newSymbol(blackChar_) ;
    public static final Sexp errorCharSexp = 
	Sexp.factory().newSymbol(errorChar_) ;

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // int value

    int value_ ;
	
    //------------------------------------------------------------
    // constructor 

    public Side(int v) { value_ = v ; } ;

    public static final Side none = new Side(none_) ;
    public static final Side white = new Side(white_) ;
    public static final Side black = new Side(black_) ;
    public static final Side error = new Side(error_) ;

    //------------------------------------------------------------
    // comparison

    public boolean isWhite() { return value_ == white_ ; } ;
    public boolean isBlack() { return value_ == black_ ; } ;
    public boolean isNone() { return value_ == none_ ; } ;
    public boolean isError() { 
	return !isWhite() && !isBlack() && !isNone() ;
    } ;
    public boolean isSame(Side s) { return value_ == s.value_ ; } ;

    public Side otherside() {
	if      (isWhite()) return black ;
	else if (isBlack()) return white ;
	else if (isNone())  return none ;
	else                return error ;
    } ;
	
    //------------------------------------------------------------
    // converter

    //----------------------------------------
    // to string

    public String toString() {
	if      (isWhite()) return whiteStr_ ;
	else if (isBlack()) return blackStr_ ;
	else if (isNone())  return noneStr_ ;
	else                return errorStr_ ;
    } ;

    //----------------------------------------
    // to string

    public String toOneChar() {
	if      (isWhite()) return whiteChar_ ;
	else if (isBlack()) return blackChar_ ;
	else if (isNone())  return noneChar_ ;
	else                return errorChar_ ;
    } ;

    //----------------------------------------
    // from string

    public static Side scan(String str) {
	if      (str.equals(whiteStr_) ||
		 str.equals(whiteChar_)) return white ;
	else if (str.equals(blackStr_)||
		 str.equals(blackChar_)) return black ;
	else if (str.equals(noneStr_) ||
		 str.equals(noneChar_))  return none ;
	else                             return error ;
    } ;

} ;


