// -*- Mode: java -*-
//Header:
//File: SynchronizedBoard.java
//Author: NODA, Itsuki
//Date: 2002/01/15
//Copyright (C) 2002 by Itsuki NODA, AIST
//EndHeader:

import BoardBase ;

//======================================================================
// class SynchronizedBoard

public class SynchronizedBoard extends BoardBase {
    public boolean move(int fx, int fy, int tx, int ty, boolean checksidep) {
	boolean r = false ;
	synchronized(this) {
	    r = super.move(fx,fy,tx,ty,checksidep) ;
	    notifyAll() ;
	} ;
	return r ;
    } ;

    public boolean execSexpState(Sexp s) throws Exception {
	boolean r = false ;
	synchronized(this) {
	    r = super.execSexpState(s) ;
	    notifyAll() ;
	} ;
	return r ;
    } ;

} ;


