/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.widgets;

import jp.highwide.resourcechecker.dialog.InputResourceDialog;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;

/**
 * `FbN{bNXt̃XgR|WbgB
 * e[ủɂ͕ҏWp(ǉAύXA폜)̃{^t<br>
 * ǉAύXɂInputResourceDialogpB
 * @see jp.highwide.resourcechecker.dialog.InputResourceDialog
 */
public class CheckBoxListEditResourceComposit extends CheckBoxListEditComposit {
	private IContainer initialContainer = null;
	/**
	 * RXgN^B
	 * @param parent ẽR|Wbg
	 * @param title ^Cg
	 * @param initialContainer InputResourceDialogŗpx[XRei
	 * @see jp.highwide.resourcechecker.dialog.InputResourceDialog#InputResourceDialog(org.eclipse.swt.widgets.Shell, String, String, String, IContainer)
	 */
	public CheckBoxListEditResourceComposit(Composite parent,
			String title,
			IContainer initialContainer) {
		super(parent, title);
		this.initialContainer = initialContainer;
	}


	/**
	 * InputResourceDialog\uǉvsB
	 * @see jp.highwide.resourcechecker.widgets.CheckBoxListEditComposit#addItemAction()
	 */
	@Override
	protected void addItemAction() {
		InputResourceDialog input = new InputResourceDialog(getShell(),
				getAddButtonTitle(),
				getAddButtonTitle(),
				getDefaultInputValue(),
				initialContainer);
		int code = input.open();
		if (code == InputDialog.CANCEL) {
			return;
		}
		addValue(input.getValue(), true);
		setDefaultInputValue(input.getValue());
	}

	/**
 	 * InputResourceDialog\uύXvsB
	 * @see jp.highwide.resourcechecker.widgets.CheckBoxListEditComposit#editItemAction()
	 */
	@Override
	protected void editItemAction() {
		int index = getCheckBoxTable().getSelectionIndex();
		if (index < 0) {
			return;
		}
		String text = getCheckBoxTable().getItem(index).getText();
		InputResourceDialog input = new InputResourceDialog(getShell(),
				getAddButtonTitle(),
				getAddButtonTitle(),
				text,
				initialContainer);
		int code = input.open();
		if (code == InputDialog.CANCEL) {
			return;
		}
		changeValue(index, input.getValue());
		setDefaultInputValue(input.getValue());
	}

}
