<?php
/**
 * 新規ブログ記事追加画面クラス
 *
 * 新規ブログ記事追加画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );

  class blogadd_entry extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------

      // セッションからエラーメッセージと入力値を取得し、削除する
      $this->gotDat[ 'errMsg' ] = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );



      //------------------------------------------------------------------------
      // デフォルト値の設定
      //------------------------------------------------------------------------

      // エラーメッセージ
      if ( empty( $this->gotDat[ 'errMsg' ][ 'message' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'message' ] = null;
      } // end of if

      // タイトル
      if ( empty( $this->gotDat[ 'errMsg' ][ 'title' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'title' ] = null;
      } // end of if

      // 本文
      if ( empty( $this->gotDat[ 'errMsg' ][ 'body' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'body' ] = null;
      } // end of if

      // トラックバックPing送信先URL
      if ( empty( $this->gotDat[ 'errMsg' ][ 'tb_url' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'tb_url' ] = null;
      } // end of if



      // 投稿日・年
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_postyear' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_postyear' ] = date( 'Y' );
      } // end of if

      // 投稿日・月
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_postmonth' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_postmonth' ] = date( 'm' );
      } // end of if

      // 投稿日・日
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_postday' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_postday' ] = date( 'd' );
      } // end of if

      // 投稿日・時
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_posthour' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_posthour' ] = date( 'G' );
      } // end of if

      // 投稿日・分
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_postminite' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_postminite' ] = date( 'i' );
      } // end of if

      // 投稿日・秒
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_postsecond' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_postsecond' ] = date( 's' );
      } // end of if



      // 公開開始日・年
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_openyear' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_openyear' ] = date( 'Y' );
      } // end of if

      // 公開開始日・月
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_openmonth' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_openmonth' ] = date( 'm' );
      } // end of if

      // 公開開始日・日
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_openday' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_openday' ] = date( 'd' );
      } // end of if

      // 公開開始日・時
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_openhour' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_openhour' ] = date( 'G' );
      } // end of if

      // 公開開始日・分
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_openminite' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_openminite' ] = date( 'i' );
      } // end of if

      // 公開開始日・秒
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_opensecond' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_opensecond' ] = date( 's' );
      } // end of if



      // 公開終了日・年
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_endyear' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_endyear' ] = null;
      } // end of if

      // 公開終了日・月
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_endmonth' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_endmonth' ] = null;
      } // end of if

      // 公開終了日・日
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_endday' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_endday' ] = null;
      } // end of if

      // 公開終了日・時
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_endhour' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_endhour' ] = null;
      } // end of if

      // 公開終了日・分
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_endminite' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_endminite' ] = null;
      } // end of if

      // 公開終了日・秒
      if ( empty( $this->gotDat[ 'errMsg' ][ 'entered_endsecond' ] ) )
      {
        $this->gotDat[ 'errMsg' ][ 'entered_endsecond' ] = null;
      } // end of if



      //------------------------------------------------------------------------
      // CKEditorが存在すれば使用する
      //------------------------------------------------------------------------
      clearstatcache();
      $this->gotDat[ 'is_ckeditor' ] = file_exists( RISOLUTO_DOCROOT . '/ckeditor/' );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',            $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',         $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',          $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'mycage',            str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) ) );

      $this->smarty->assign ( 'is_ckeditor',       $this->gotDat[ 'is_ckeditor' ] );
      $this->smarty->assign ( 'base_url',          str_replace( 'index.php', '', $this->obj_util->getBaseUrl() ) );

      $this->smarty->assign ( 'errMsg',            $this->gotDat[ 'errMsg' ][ 'message' ] );
      $this->smarty->assign ( 'entered_title',     $this->gotDat[ 'errMsg' ][ 'title'   ] );
      $this->smarty->assign ( 'entered_body',      $this->gotDat[ 'errMsg' ][ 'body'    ] );
      $this->smarty->assign ( 'entered_tb_url',    $this->gotDat[ 'errMsg' ][ 'tb_url'  ] );

      // ブログ投稿日（表示用）・年（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postyear',   $this->gotDat[ 'errMsg' ][ 'entered_postyear'   ] );
      // ブログ投稿日（表示用）・月（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postmonth',  $this->gotDat[ 'errMsg' ][ 'entered_postmonth'  ] );
      // ブログ投稿日（表示用）・日（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postday',    $this->gotDat[ 'errMsg' ][ 'entered_postday'    ] );
      // ブログ投稿日（表示用）・時（デフォルト表示項目）
      $this->smarty->assign ( 'entered_posthour',   $this->gotDat[ 'errMsg' ][ 'entered_posthour'   ] );
      // ブログ投稿日（表示用）・分（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postminite', $this->gotDat[ 'errMsg' ][ 'entered_postminite' ] );
      // ブログ投稿日（表示用）・秒（デフォルト表示項目）
      $this->smarty->assign ( 'entered_postsecond', $this->gotDat[ 'errMsg' ][ 'entered_postsecond' ] );

      // 公開開始日・年（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openyear',   $this->gotDat[ 'errMsg' ][ 'entered_openyear'   ] );
      // 公開開始日・月（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openmonth',  $this->gotDat[ 'errMsg' ][ 'entered_openmonth'  ] );
      // 公開開始日・日（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openday',    $this->gotDat[ 'errMsg' ][ 'entered_openday'    ] );
      // 公開開始日（表示用）・時（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openhour',   $this->gotDat[ 'errMsg' ][ 'entered_openhour'   ] );
      // 公開開始日（表示用）・分（デフォルト表示項目）
      $this->smarty->assign ( 'entered_openminite', $this->gotDat[ 'errMsg' ][ 'entered_openminite' ] );
      // 公開開始日（表示用）・秒（デフォルト表示項目）
      $this->smarty->assign ( 'entered_opensecond', $this->gotDat[ 'errMsg' ][ 'entered_opensecond' ] );

      // 公開終了日・年（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endyear',   $this->gotDat[ 'errMsg' ][ 'entered_endyear'   ] );
      // 公開終了日・月（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endmonth',  $this->gotDat[ 'errMsg' ][ 'entered_endmonth'  ] );
      // 公開終了日・日（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endday',    $this->gotDat[ 'errMsg' ][ 'entered_endday'    ] );
      // 公開終了日（表示用）・時（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endhour',   $this->gotDat[ 'errMsg' ][ 'entered_endhour'   ] );
      // 公開終了日（表示用）・分（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endminite', $this->gotDat[ 'errMsg' ][ 'entered_endminite' ] );
      // 公開終了日（表示用）・秒（デフォルト表示項目）
      $this->smarty->assign ( 'entered_endsecond', $this->gotDat[ 'errMsg' ][ 'entered_endsecond' ] );

      // ブログ投稿日（表示用）・年（セレクトボックス表示用）
      $this->smarty->assign ( 'arrPostedYear',     $this->obj_util->genYear( false, date( 'Y' ) - 5, 10, 0 ) );
      // 公開開始日・年（セレクトボックス表示用）
      $this->smarty->assign ( 'arrOpenYear',       $this->obj_util->genYear( false, date( 'Y' ), 5, 0 ) );
      // 公開終了日・年（セレクトボックス表示用）
      $this->smarty->assign ( 'arrEndYear',        $this->obj_util->genYear( true,  date( 'Y' ), 5, 0 ) );

      // 月（セレクトボックス表示用）
      $this->smarty->assign ( 'arrMonth',          $this->obj_util->genMonth( false ) );
      // 日（セレクトボックス表示用）
      $this->smarty->assign ( 'arrDay',            $this->obj_util->genDay( false ) );
      // 時（セレクトボックス表示用）
      $this->smarty->assign ( 'arrHour',           $this->obj_util->genHour( false, true ) );
      // 分・秒（セレクトボックス表示用）
      $this->smarty->assign ( 'arrMinSec',         $this->obj_util->genMinSec( false ) );

      // 月（セレクトボックス表示用）、公開終了日用
      $this->smarty->assign ( 'arrMonth_end',      $this->obj_util->genMonth( true ) );
      // 日（セレクトボックス表示用）、公開終了日用
      $this->smarty->assign ( 'arrDay_end',        $this->obj_util->genDay( true )   );
      // 時（セレクトボックス表示用）、公開終了日用
      $this->smarty->assign ( 'arrHour_end',       $this->obj_util->genHour( true, true ) );
      // 分・秒（セレクトボックス表示用）、公開終了日用
      $this->smarty->assign ( 'arrMinSec_end',     $this->obj_util->genMinSec( true ) );

      // 表示
      $this->smarty->display( 'blogadd_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:blogadd_entry

?>
