<?php
/**
 * アップグレードFlavor画面(1)クラス
 *
 * アップグレードFlavor画面(1)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page01 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない or 前画面のActが「upgrade」 and 「page01」 and 「page02」でない場合、
      // アップグレードFlavorに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or  ( $tmp_act != 'upgrade' and  $tmp_act != 'page01' and  $tmp_act != 'page02' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // チェック対象をセットする
      // 他にチェック対象があれば、この配列に加えてください。
      // path: チェック対象となるパス / stat: あるべき状態（writable: 書込可 / readable: 読込可）
      // readableを指定したとき、その対象が書込可の場合はNGとなります
      $this->checklist = array(
                                array(
                                       'path' => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_DOCROOT . '/js/'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_DOCROOT . '/js/simpleblog_fckeditor_config.js'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_CONF
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_CONF . 'simpleblog.ini'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/menu/00005_simpleblog.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/AUTHORS'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/LICENSE'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogadd_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogadd_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogadd_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogadd_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogadd_entry.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogadd_entry.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogcomment.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogcomment.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogdel_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogdel_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogdel_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogdel_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/bloglist.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/bloglist.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogmod_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogmod_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogmod_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogmod_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogmod_entry.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogmod_entry.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogview.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/blogview.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/comment_add.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/comment_del.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/comment_ng.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/comment_ok.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/commentlist.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/commentlist.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/rss.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/rss_1.0.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/simpleblog_base.inc'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/tb.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/trackback_del.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/trackback_ng.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/trackback_ok.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/trackbacklist.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/trackbacklist.php'
                                     , 'stat' => 'writable'
                                     )
                              );

      // チェックメソッドを呼び出し、結果を整形
      foreach( $this->checklist as $dat )
      {
        $tmp_result = $this->obj_util->statChecker( $dat );
        if ( $tmp_result[ 'result' ] == 'NG' )
        {
          $this->errStatus = 'NG';
        } // end of if
        $this->checkresult[] = $tmp_result;
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(1)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page01.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page01
?>
