<?php
/**
 * アップグレードFlavor画面(6)クラス
 *
 * アップグレードFlavor画面(6)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page05 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない  or 前画面のActが「page04」 and 「page05」 and 「page06」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or ( $tmp_act != 'page04' and $tmp_act != 'page05' and $tmp_act != 'page06' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // 配置対象をセットする
      // 他に配置する対象があれば、この配列に加えてください。
      // target: 対象ファイル名 / destination: 配置先のパス/パーミッション/オーナ名/グループ名） / 
      // operation: 操作の内容(copy/move/unlink/mkdir/rmdir)
      $this->filelist = array(
                                array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/simpleblog_ckeditor.js'
                                     , 'destination' => RISOLUTO_DOCROOT . '/js/simpleblog_ckeditor.js'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_DOCROOT . '/js/simpleblog_fckeditor_config.js'
                                     , 'destination' => RISOLUTO_DOCROOT . '/js/UNUSED_simpleblog_fckeditor_config.js'
                                     , 'operation'   => 'move'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/simpleblog.ini'
                                     , 'destination' => RISOLUTO_CONF . 'simpleblog.ini'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/simpleblog_version'
                                     , 'destination' => RISOLUTO_CONF . 'simpleblog_version'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/00005_simpleblog.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu/00005_simpleblog.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/AUTHORS'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/AUTHORS'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/LICENSE'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/LICENSE'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogadd_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogadd_complete.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogadd_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogadd_complete.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogadd_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogadd_confirm.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogadd_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogadd_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogadd_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogadd_entry.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogadd_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogadd_entry.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogcomment.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogcomment.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogcomment.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogcomment.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogdel_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogdel_complete.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogdel_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogdel_complete.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogdel_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogdel_confirm.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogdel_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogdel_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/bloglist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/bloglist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/bloglist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/bloglist.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogmod_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogmod_complete.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogmod_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogmod_complete.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogmod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogmod_confirm.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogmod_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogmod_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogmod_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogmod_entry.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogmod_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogmod_entry.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/bloglist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/bloglist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/bloglist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/bloglist.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogview.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogview.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/blogview.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/blogview.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/comment_add.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/comment_add.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/comment_del.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/comment_del.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/comment_ng.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/comment_ng.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/comment_ok.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/comment_ok.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/commentlist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/commentlist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/commentlist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/commentlist.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/rss.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/rss.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/rss_1.0.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/rss_1.0.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/simpleblog_base.inc'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/simpleblog_base.inc'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/tb.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/tb.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/trackback_del.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/trackback_del.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/trackback_ng.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/trackback_ng.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/trackback_ok.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/trackback_ok.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/trackbacklist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/trackbacklist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/upgrade_simpleblog-1_1_0_to_simpleblog-1_2_0/file/trackbacklist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'simpleblog/trackbacklist.tpl'
                                     , 'operation'   => 'copy'
                                     )
                             );

      // 処理を行う
      foreach( $this->filelist as $dat )
      {

        // 処理を呼び出す
        $tmp_errflag = $this->obj_util->fileOperator( $dat[ 'operation' ], $dat[ 'target' ], $dat[ 'destination' ] );

        // 処理結果によって、状態を変える
        if ( ! $tmp_errflag )
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'OK'
                                      );
        } // end of if
        else
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'NG'
                                      );
          $this->errStatus     = 'NG';
        } // end of else
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(5)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page05.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page05
?>
