<?php
/* ========================================================================
 - [htdocs/setup.php]
 -      セットアップ用フロントコントローラー
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/10/02] Smarty用の定義追加
 -      [2006/09/29] モジュール等の読み込み内容を修正
 -      [2006/09/29] データベースを使用する処理を排除
 -      [2006/09/05] データベースの初期設定を追加
 -      [2006/08/25] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once '../sns_config.php';

/* ---------------------------------------- */
/* PC用各種ディレクトリ設定 */
define('WEBAPP_DIR',BASE_DIR.'webapp'.DIRECTORY_SEPARATOR);         // ウェブアプリケーションパス
define('WEBAPP_LIB_DIR',WEBAPP_DIR.'libs'.DIRECTORY_SEPARATOR);     // ウェブライブラリパス
define('MODULE_DIR',WEBAPP_DIR.'modules'.DIRECTORY_SEPARATOR);      // モジュールパス

/* ---------------------------------------- */
/* RKTフレームワーク用定義 */
define('RKT_INCLUDE_ACCOUNT',WEBAPP_LIB_DIR.'account.php');         // アカウントクラスファイル

/* ---------------------------------------- */
/* Smarty（テンプレートエンジン）の定義部分 */
define('SMARTY_TEMPLATE_DIR', WEBAPP_DIR.'templates'. DIRECTORY_SEPARATOR); // テンプレートパス
define('SMARTY_COMPILE_DIR', COMPILE_DIR.'webapp'.DIRECTORY_SEPARATOR);     // テンプレート一時コンパイルパス
/* ---------------------------------------- */

// ------------------------------------------------
// 実行関数
// 引数         なし
// 戻り値       なし
// ------------------------------------------------
function _main()
{
    $include_file = array ('check','config','admin','database');

    $page = empty($_REQUEST['page'])?'check':$_REQUEST['page'];
    $page = in_array($page,$include_file)?$page:'check';
    $include = 'setup/'.$page.'.php';

    header('Content-Type: text/html; charset=utf-8');

    include_once MODULE_DIR.$include;

    $obj_webapp = new webapp();
    $obj_webapp->execute();
}
_main();    // 実行関数
?>
