<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */

 /**
 * Smarty plugin
 *
 * Type:     modifier<br>
 * Name:     rkt_date_format<br>
 * Purpose:  NvZ
 * Example:  {$text|rkt_date_format}<br>
 * Example:  {$text|rkt_date_format:'%b %e, %Y'}<br>
 * @version  1.0
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @param string
 * @param string
 * @return string
 */
function smarty_modifier_rkt_date_format($date, $format="%b %e, %Y",)
{
    include_once LIB_DIR.'rkt_calendar.php';

    $dates = RKT_calendar::splitDate($date);
    $timestamp = mktime(
                    $dates['hour'],
                    $dates['minute'],
                    $dates['seconds'],
                    $dates['month'],
                    $dates['day'],
                    $dates['year']);

    $dates = RKT_calendar::splitDate($date);
    $dates['year']  = intval($dates['year']);
    $dates['month'] = intval($dates['month']);
    $dates['day']   = intval($dates['day']);

    $year   = intval(date('Y'));
    $now_md = intval(date('md'));

    $born_md = sprintf('%d%02d',$dates['month'], $dates['day']);
    $born_md = intval($born_md);

    $age = $year - $dates['year'];
    $age = ($now_md >= $born_md)?$age:$age-1;

    return $age;
}

/* vim: set expandtab: */

?>
