<?php
/* ========================================================================
 - [modules/community/edit/community.php]
 -      コミュニティ基礎情報
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/06/17] コミュニティ：トピック、イベント、記事、アンケート権限追加
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/edit/community.tpl');
        
        if (!$this->admin){
            $this->ref_community = 0;
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/edit/community/'.$this->sid.'/'.$this->ref_community.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_community');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->ref_community = $this->objmnp->getCurID();

            $this->init_community();
            header('Location: '.HTTP_ACTION.'community/show/community/'.$this->sid.'/'.$this->ref_community.'/');
            exit();
        } elseif ($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'community/edit/community/'.$this->sid.'/'.$this->ref_community.'/confirm/');
            exit();
        }

        /* 削除 */
        if ($this->delete_community()){
            header('Location: '.HTTP_ACTION.'community/edit/community/'.$this->sid.'/complete/');
            exit();
        }

        $this->set_category();
        $this->set_prefecture();

        $visibilitys = array(
            VISIBILITY_PUBLIC=>  VISIBILITY_LABEL_PUBLIC_ENTRY,
            VISIBILITY_PRIVATE=> VISIBILITY_LABEL_PRIVATE_ENTRY,
            VISIBILITY_HIDDEN=>  VISIBILITY_LABEL_HIDDEN_ENTRY,
        );
        $this->Assign('visibilitys', $visibilitys);
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'com_category '.
            'ORDER BY '.
                'ref_genre,sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
        }
        
        $this->Assign('categorys',$list);
    }

    /**
     * 都道府県の設定
     *
     * @access private
     * @return void
     */
    function set_prefecture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'prefecture '.
            'FROM '.
                DB_PREFIX.'ara_prefecture '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['prefecture'];
        }
        
        $this->Assign('prefectures',$list);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!empty($this->ref_community)){
            $this->objmnp->setCurID($this->ref_community);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('avail', AVAIL_ENABLE);

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
            'ref_blog',
            'total',
            'access_num',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * 初期化設定
     *
     * @access private
     * @return void
     */
    function init_community()
    {
        $action = $this->objmnp->getActionFlag();
        if ($action != RKT_MANIP_INSERT){
            return ;
        }
        
        $this->insert_names();
        $this->make_dir();
    }

    /**
     * 名簿を新規登録
     *
     * @access private
     * @return boolean  真偽値
     */
    function insert_names()
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'com_names('.
                    'modify,'.
                    'ref_community,'.
                    'ref_account,'.
                    'status'.
                ') VALUES ('.
                    "'".date('Y-m-d H:i:s')."',".
                    $this->ref_community.','.
                    $this->account['id'].','.
                    STATUS_COMMUNITY_ADMIN.
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * コミュニティ用アーカイブディレクトリの作成
     *
     * @access private
     * @return void
     */
    function make_dir()
    {
        if (BLOB_DRIVER == 'db'){
            return ;
        }
        /* ID別ディレクトリ */
        $upper = intval($this->ref_community / 1000); 
        $dir = COMMUNITY_DIR.$upper.'000';
        if (!file_exists($dir)){
            mkdir($dir, 0777);
        }

        /* コミュニティ用ディレクトリ */
        $dir .= DIRECTORY_SEPARATOR.$this->ref_community;
        mkdir($dir, 0777);

        mkdir($dir.DIRECTORY_SEPARATOR.'large', 0777);
        mkdir($dir.DIRECTORY_SEPARATOR.'small', 0777);
    }

    /**
     * コミュニティの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_community()
    {
        if (empty($_POST['delete'])){
            return false;
        }
        /* 画像の削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community;
        $this->objdb->exec($sql);

        /* 名簿の削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_community = '.$this->ref_community;
        $this->objdb->exec($sql);

        /* コメントの削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_community = '.$this->ref_community;
        $this->objdb->exec($sql);

        /* イベント参加の削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community = '.$this->ref_community;
        $this->objdb->exec($sql);

        /* トピックの削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_topic '.
            'WHERE '.
                'ref_community = '.$this->ref_community;
        $this->objdb->exec($sql);

        /* コミュニティの削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_community '.
            'WHERE '.
                'id = '.$this->ref_community;
        $this->objdb->exec($sql);

        /* 関連画像実体の削除 */
        $objfile = RKT_upload::getInstance();
        $objfile->delete(array('gid'=>$this->ref_community));

        /* ポータル用トピック・イベントデータの削除 */
        $this->request_delete();

        return true;
    }
} // webapp
?>
