<?php
/* ========================================================================
 - [modules/friend/edit/message.php]
 -      メッセージを送る
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/03/08] 下書き時にも自動通知メールが送信されるエラーを修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * メッセージID
     * @var integer
     */
    var $id = null;

    /**
     * relation状況
     * @var integer
     */
    var $relation = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/edit/message.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('relation');
        $this->Assign('relation', $this->relation);
        
        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'friend/edit/message/'.$this->sid.'/'.$this->ref_friend.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'fri_message');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->do_send_message();
            header('Location: '.HTTP_ACTION.'private/message/list/'.$this->sid.'/'.$this->objmnp->getValue('status').'/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'friend/edit/message/'.$this->sid.'/'.$this->ref_friend.'/confirm/');
            exit();
        }
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $statuses = array(
            'manip'=> MESSAGE_SENT,
            'draft'=> MESSAGE_DRAFT,
            'validate'=> MESSAGE_DRAFT
        );
        $status = empty($_POST['manip'])?'validate':'manip';
        $status = empty($_POST['draft'])?$status:'draft';

        // 直接入力
        $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('ref_to',  $this->ref_friend);
        $this->objmnp->setValue('ref_from',$this->account['id']);
        $this->objmnp->setValue('status', $statuses[$status]);
        $this->objmnp->setValue('flag', MESSAGE_FLAG_READ);


        // 更新しない項目名
        $skip = array(
            'ref_account',
            'ref_message',
        );
        return $this->objmnp->execute($this, $skip);
    }

    /**
     * メッセージの送信
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_send_message()
    {
        if ($this->objmnp->getValue('status') != MESSAGE_SENT){
            return false;
        }

        $this->send_mail();

        $value = array(
            'modify'=> $this->objmnp->getValue('modify'),
            'regist_date'=> $this->objmnp->getValue('regist_date'),
            'ref_account'=> $this->objmnp->getValue('ref_to'),
            'ref_to'=> $this->objmnp->getValue('ref_to'),
            'ref_from'=> $this->objmnp->getValue('ref_from'),
            'subject'=> $this->objmnp->getValue('subject'),
            'body'=> $this->objmnp->getValue('body'),
        );

        $sql =
            'INSERT INTO '.
                DB_PREFIX.'fri_message('.
                    'modify,'.
                    'regist_date,'.
                    'status,'.
                    'ref_account,'.
                    'ref_to,'.
                    'ref_from,'.
                    'flag,'.
                    'subject,'.
                    'body'.
                ') VALUES ('.
                    "'".$value['modify']."',".
                    "'".$value['regist_date']."',".
                    MESSAGE_INBOX.','.
                    $value['ref_account'].','.
                    $value['ref_to'].','.
                    $value['ref_from'].','.
                    MESSAGE_FLAG_UNREAD.','.
                    "'".$value['subject']."',".
                    "'".$value['body']."'".
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * 自動通知メール
     *
     * @access private
     * @return void
     */
    function send_mail()
    {
        $sql=
            'SELECT '.
                'nickname '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $objmail = new sendmail('message');

        $objmail->Assign('user_name', $this->friend['nickname']);
        $objmail->Assign('friend', $infos['nickname']);
        $objmail->Assign('url', HTTP_ACTION.'private/message/list/');

        $to = sql_query::decrypt($this->friend['email']);
        $objmail->send($to);
    }
} // webapp
?>
