<?php
/* ========================================================================
 - [modules/friend/show/friends.php]
 -      友達一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/show/friends.tpl');

        $this->set_friend();
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friend()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = fri.ref_friend AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'fri.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'act.last_login DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();        
        $this->Assign('friends', $result);
    }
} // webapp
?>
