<?php
/* ========================================================================
 - [modules/member/exit.php]
 -      退会処理
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';
require_once WEBAPP_LIB_DIR.'private/act_exit.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/account/exit.tpl');        
        
        if ($this->is_owner()){
            $this->Assign('owner', true);
            return ;
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/account/exit/'.$this->sid.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_exit');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->set_avail();
            $actext = new act_exit($this->account['id']);
            $actext->execute();

            header('Location: '.HTTP_ACTION.'public/login/exit/'.$this->sid.'/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/account/exit/'.$this->sid.'/confirm/');
            exit();
        }
    }

    /**
     * コミュニティオーナーか？
     *
     * @access private
     * @return void
     **/
    function is_owner()
    {
        $sql=
            'SELECT '.
                'count(ref_account) as ct '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'status = '.STATUS_COMMUNITY_ADMIN.' AND '.
                'ref_account='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return !empty($result['ct']);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);

        // 更新しない項目名
        $skip = array(
            'status',
        );
        return $this->objmnp->execute($this, $skip);
    }

    /**
     * 会員有効フラグの設定
     *
     * @access private
     * @return boolean  真偽値
     */
    function set_avail()
    {
        $sql =
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                'avail = '.AVAIL_DISABLE.' '.
            'WHERE '.
                'id = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }
} // webapp
?>
