<?php
/* ========================================================================
 -  [modules/public/login/entrance.php]
 -      ログインフォーム
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 -  更新履歴：
 -      [2007/06/20] XSS対応
 -      [2007/05/27] 携帯端末IDによる自動ログイン処理の追加
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * URL
     * @var integer
     */
    var $url = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/login/entrance.tpl');

        /* URL引数の取得 */
        $this->setSafety('url','_REQUEST','string');
        $url = $this->get_sidurl($this->url);

        $objauth = new RKT_auth();
        if ($objauth->autoLoginUserAgentID()){
            header('Location: '.$url);
            $this->print_url($url);
            exit();
        }
        $objauth->logOut();

        $this->Assign('sessionid', RKT_auth::getSessionID());
        $this->Assign('url', $url);

        $this->Assign('mismatch', !empty($_GET['mismatch']));
    }

    /**
     * SessionID付URLの取得
     *
     * @access public
     * @return void
     **/
    function get_sidurl($url)
    {
        $sid = RKT_auth::getSessionID();

        $param = explode('exec'.WAP_ACTION_STYLE,$url);
        $url   = $param[1];
        $parse = explode('/',$url);

        $url = $param[0].'exec'.WAP_ACTION_STYLE;
        foreach ($parse as $row=>$value){
            if ($row == 4){
                $url .= $sid.'/';
            }
            $url .= $value.'/';
        }
        return substr($url,0,-1);
    }

    /**
     * パスインフォ付の自URLの取得
     *
     * @access public
     * @return string
     */
    function get_self()
    {
        $self = $_SERVER['REQUEST_URI'];
        $needle = array(
            'QUERY_STRING'=>   '/',
            'PATH_INFO'=>      '?',
            'ORIG_PATH_INFO'=> '?',
        );
        $addstr = array(
            'QUERY_STRING'=>   '/',
            'PATH_INFO'=>      '',
            'ORIG_PATH_INFO'=> '',
        );

        $pos = strrpos($self, $needle[PATH_INFO_KEY]);
        if (!empty($pos)){
            $self = substr($self,0,$pos);
        }

        return $self.$addstr[PATH_INFO_KEY];
    }

    /**
     * リダイレクト出来ない場合の表示
     *
     * @access public
     * @return void
     **/
    function print_url($url)
    {
        $body  = '<html>';
        $body .= '<head>';
        $body .= '<meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS">';
        $body .= '<title>{$base.title}</title>';
        $body .= '</head>';
        $body .= '<body>';
        $body .= '<h1 align="center"><font color="#087794">'.WAP_SYSTEM_NAME.'</font></h1><hr />';
        $body .= '<a accesskey="0" href="'.$url.'">[0]ページ移動</a>';
        $body .= '<hr />'.COPYRIGHT;
        $body .= '</body>';
        $body .= '</html>';

        $body = mb_convert_encoding($body, 'SJIS', 'UTF-8');
        print($body);
    }
} // webapp
?>
