<?php
/* ========================================================================
 - [webapp/libs/wap_admin.php]
 -      WebApplicationクラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/06/18] 日記の公開レベルを追加
 -      [2006/09/20] $this->base['uri_separator']を追加
 -      [2006/08/27] ベーステンプレートをコンストラクタで指定
 -      [2006/07/17] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_validate.php';
require_once LIB_DIR.'rkt_auth.php';
require_once LIB_DIR.'rkt_webapp.php';

/**
 * WebApplicationクラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package WAP_admin
 * @access public
 * @version 1.0
 */
class WAP_admin extends RKT_webapp
{
    /**
     * アカウント情報
     * @var object
     */
    var $accounts = array();

    /**
     * error情報
     * @var boolean
     */
    var $error = false;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function WAP_admin()
    {
        $this->RKT_webapp();
        $this->init_tplargs();

        $objact = account::getInstance();
        $this->account = $objact->getInfo();
        $this->base['account'] = $this->account;

        $this->setTemplateBase('base/admin.tpl');
        $this->base['menu'] = 'menu/admin.tpl';
        $this->addCss('common.css');
        $this->addCss('admin.css');
    }

    /**
     * 実行処理
     *
     * @access public
     **/
    function execute()
    {
    }

    /**
     * 表示処理
     *
     * @access public
     * @return void
     **/
    function display()
    {
        if ($this->error){
            $this->template_file = 'error.tpl';
            error_log('WAP_admin::error();'."\t".
                        $this->objdb->sqlerror."\r\n", 3, ERROR_LOG_FILE);
        }
        $this->mixOutput();
    }

    /**
     * テンプレート引数の初期化
     *
     * @access private
     */
    function init_tplargs()
    {
        $this->base['sid']  = session_id();
        $this->base['url']  = BASE_URL;
        $this->base['http'] = HTTP_ACTION;
        $this->base['ssl']  = SSL_ACTION;

        $this->base['uri_separator']  = htmlspecialchars(WAP_URI_SEPARATOR);
    }
}
// WAP_adminの終了
?>
