<?php
/* ========================================================================
 - [modules/community/edit/entry.php]
 -      コミュニティに参加
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/12] コミュニティメンバーステータスをビットフラグに変更
 -      [2006/08/27] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/edit/entry.tpl');

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/edit/entry/'.$this->ref_community.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'com_names');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->update_total();
            if ($this->objmnp->getValue('status') == STATUS_COMMUNITY_MEMBER){
                $_SESSION['updated_names'] = 1;
                header('Location: '.HTTP_ACTION.'community/show/member/'.$this->ref_community.'/');
            } else {
                header('Location: '.HTTP_ACTION.'community/edit/entry/'.$this->ref_community.'/complete/');
            }
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'community/edit/entry/'.$this->ref_community.'/confirm/');
            exit();
        }
        if($this->community['visibility'] == VISIBILITY_PUBLIC && !preg_match('/confirm/i',$_SERVER['REQUEST_URI'])) {
            header('Location: '.HTTP_ACTION.'community/edit/entry/'.$this->ref_community.'/confirm/');
            exit();
        }
        
        $this->set_status();
    }

    /**
     * メンバーかの判定
     *
     * @access private
     * @return void
     */
    function set_status()
    {
        $sql=
            'SELECT '.
                'status '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $status = empty($result['status'])?0:$result['status'];
        $this->Assign('status', $status);
    }

    /**
     * カレントIDの取得
     *
     * @access private
     * @return integer
     */
    function get_curid()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return empty($result['id'])?null:$result['id'];
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $curid = $this->get_curid();
        // 新規登録以外の処理
        if (!empty($curid)){
            $this->objmnp->setCurID($curid);
        } else {
            $this->objmnp->setValue('ref_community', $this->ref_community);
            $this->objmnp->setValue('ref_account', $this->account['id']);
        }

        $statuses = array(
            VISIBILITY_PUBLIC=>  STATUS_COMMUNITY_MEMBER,
            VISIBILITY_PRIVATE=> STATUS_COMMUNITY_REQUEST,
            VISIBILITY_HIDDEN=>  STATUS_COMMUNITY_REQUEST,
        );

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('status', $statuses[$this->community['visibility']]);

        // 更新しない項目名
        $skip = array(
            'ref_community',
            'ref_account',
            'avail',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * 会員総数を更新
     *
     * @access private
     * @return void
     */
    function update_total()
    {
        $sql = 
            'SELECT '.
                'count(id) as total '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_community = '.$this->ref_community. ' AND '.
                sql_query::bitFlag('status & '.STATUS_COMMUNITY_MEMBERS);
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $total = empty($result['total'])?0:$result['total'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_community '.
            'SET '.
                'total = '.$total.' '.
            'WHERE '.
                'id = '.$this->ref_community;
        $this->objdb->exec($sql);
    }
} // webapp
?>
