<?php
/* ========================================================================
 - [modules/private/account/account.php]
 -      会員基礎情報
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/account/account.tpl');        

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/account/account/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_account');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            header('Location: '.HTTP_ACTION.'private/account/account/complete/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/account/account/confirm/');
            exit();
        }
    }

    /**
     * 入力されたe-mailがユニークか
     *
     * @access private
     * @return boolean 正常時：真
     */
    function is_unique()
    {
        if (empty($_POST['email'])){
            return true;
        }
        $email_hash = md5($_POST['email']);
        $sql=
            'SELECT '.
                'count(email_hash) as ct '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                "email_hash = '".$email_hash."' AND ".
                'avail = '.AVAIL_ENABLE.' AND '.
                'id != '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return empty($result['ct']);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $this->objmnp->setCurID($this->account['id']);

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));

        // ログイン名のユニークチェック
        if (!$this->is_unique()){
            $this->objmnp->setAlert('unique');
        }

        /* 初期データの加工設定 */
        $func = array('sql_query', 'decrypt');
        $this->objmnp->setInitEffect('email', array('func'=>$func));
        $this->objmnp->setInitEffect('cellular', array('func'=>$func));

        /* 入力データの加工設定 */
        $func = array('sql_query', 'hash');
        $this->objmnp->setInputEffect('email_hash', array('func'=>$func, 'key'=>'email'));
        $this->objmnp->setInputEffect('cellular_hash', array('func'=>$func, 'key'=>'cellular'));

        $func = array('sql_query', 'encrypt');
        $this->objmnp->setInputEffect('email', array('func'=>$func));
        $this->objmnp->setInputEffect('cellular', array('func'=>$func));

        // 更新しない項目名
        $skip = array(
            'last_login',
            'regist_date',
            'avail',
            'password',
            'status',
            'email_hash',
            'cellular_hash',
            'ref_blog',
            'total',
            'friend_number',
        );
        return $this->objmnp->execute($this, $skip);
    }
} // webapp
?>
