<?php
/* ========================================================================
 - [modules/private/home/home.php]
 -      Myホーム
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/12] コミュニティメンバーステータスをビットフラグに変更
 -      [2006/09/04] コミュニティ掲示板の一覧が表示されないエラーを修正
 -      [2006/07/10] 表示整形の不具合修正
 -      [2006/08/27] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * スケジュールリスト
     * @var string
     */
    var $term = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/home/home.tpl');

        $timestamp = strtotime(TERM_MYHOME_NEWS);
        $this->term = $this->objdb->quote(date('Y-m-d H:i:s', $timestamp));

        $this->set_info();

        $this->set_friend_relation();
        $this->set_admin_change();
        $this->set_community_entry();
        $this->set_new_message();
        $this->set_new_comment();

        $this->set_today();
        $this->set_friend();
        $this->set_community();
        $this->set_community_number();

        $this->set_post();
        $this->set_topic();
        $this->set_forum();
        $this->set_fdiary();
        $this->set_diary();
        $this->set_comment();
        $this->set_review();

        $this->set_intro();
    }

    /**
     * お知らせの設定
     *
     * @access private
     * @return void
     */
    function set_info()
    {
        $sql = 
            'SELECT '.
                'itm.id as id,'.
                'itm.origin as origin,'.
                'itm.open_date as open_date,'.
                'itm.subject as subject '.
            'FROM '.
                DB_PREFIX.'itm_item itm '.
            'WHERE '.
                'itm.avail = '.AVAIL_ENABLE.' '.
            'ORDER BY '.
                'itm.open_date DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('infos', $result);
    }

    /**
     * 友達登録の設定
     *
     * @access private
     * @return void
     */
    function set_friend_relation()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_THROW.' AND '.
                'ref_account='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('friend_relation', $result['ct']);
    }

    /**
     * 管理人交代の設定
     *
     * @access private
     * @return void
     */
    function set_admin_change()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'status = '.STATUS_COMMUNITY_CHANGE.' AND '.
                'ref_account='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('admin_change', $result['ct']);
    }

    /**
     * コミュニティ参加の設定
     *
     * @access private
     * @return void
     */
    function set_community_entry()
    {
        $sql=
            'SELECT '.
                'count(nam.id) as ct '.
            'FROM '.
                DB_PREFIX.'com_community com,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'com.id = nam.ref_community AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'nam.status = '.STATUS_COMMUNITY_REQUEST.' AND '.
                'com.ref_account='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('community_entry', $result['ct']);
    }

    /**
     * 未読メッセージの設定
     *
     * @access private
     * @return void
     */
    function set_new_message()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'fri_message '.
            'WHERE '.
                'flag = '.MESSAGE_FLAG_UNREAD.' AND '.
                'status = '.MESSAGE_INBOX.' AND '.
                'ref_account='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('new_message', $result['ct']);
    }

    /**
     * 未読コメントの設定
     *
     * @access private
     * @return void
     */
    function set_new_comment()
    {
        $sql=
            'SELECT '.
                'cmt.ref_entry as ref_entry '.
            'FROM '.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_comment cmt '.
            'WHERE '.
                'dia.id = cmt.ref_diary AND '.
                'cmt.flag = '.MESSAGE_FLAG_UNREAD.' AND '.
                'dia.ref_account = '.$this->account['id'].' '.
            'GROUP BY '.
                'cmt.ref_entry';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('new_comment', count($result));

        $sql=
            'SELECT '.
                'cmt.ref_entry ref_entry '.
            'FROM '.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_comment cmt '.
            'WHERE '.
                'dia.id = cmt.ref_diary AND '.
                'cmt.flag = '.MESSAGE_FLAG_UNREAD.' AND '.
                'dia.ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('new_comment_entry', $result['ref_entry']);
    }

    /**
     * 今日の日付の設定
     *
     * @access private
     * @return void
     */
    function set_today()
    {
        $day = date('w');
        $weeks = array(
            '日','月','火','水','木','金','土'
        );
        
        $today = array(
            'date'=> date('n/j'),
            'day' => $weeks[$day]
        );
        $this->Assign('today', $today);
    }

    /**
     * 情報の成形
     *
     * @access private
     * @return void
     */
    function shape_list($values)
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($values as $value){
            // 改行処理
            if ($column >= 3){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } // foreach ($result as $value)
        
        return $list;
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friend()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = fri.ref_friend AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'fri.ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'act.last_login DESC '.
            'LIMIT 9';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $row = count($result);
        $inits = array (0,2,1);
        for ($row=$inits[$row%3]; $row; $row--){
            $result[] = array(
                'name'=> '',
                'friends'=>0,
                'subject'=> '',
                'src'=>    '',
                'width'=>  0,
                'height'=> 0
            );
        }
        $this->Assign('friends', $this->shape_list($result));
    }

    /**
     * グループの設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.community as community,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.','.
                DB_PREFIX.'com_names nms '.
            'WHERE '.
                'com.id = nms.ref_community AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                sql_query::bitFlag('nms.status & '.STATUS_COMMUNITY_MEMBERS).' AND '.
                'nms.ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'com.modify DESC '.
            'LIMIT 9';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            $this->Assign('communitys', null);
            return ;
        }

        $list = array();
        $row=0;
        foreach ($result as $value){
            $value['src'] = empty($value['src'])?BASE_URL.NOPHOTO_SMALL:BASE_URL.$value['src'];
            $value['width'] = empty($value['width'])?PHOTO_SMALL_SIZE:$value['width'];
            $value['height'] = empty($value['height'])?PHOTO_SMALL_SIZE:$value['height'];

            $list[] = array(
                'id'=> $value['id'],
                'community'=> $value['community'],
                'src'=> $value['src'],
                'width'=> $value['width'],
                'height'=> $value['height'],
            );
            $row++;
        }

        $inits = array (0,2,1);
        for ($row=$inits[$row%3]; $row; $row--){
            $list[] = array(
                'id'=> '',
                'community'=> '',
                'src'=>    '',
                'width'=>  0,
                'height'=> 0
            );
        }

        $this->Assign('communitys', $this->shape_list($list));
    }

    /**
     * グループ数の設定
     *
     * @access private
     * @return void
     */
    function set_community_number()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                sql_query::bitFlag('status & '.STATUS_COMMUNITY_MEMBERS);
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('community_num',$result['ct']);
    }

    /**
     * 日記書き込みの設定
     *
     * @access private
     * @return void
     */
    function set_post()
    {
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'com.modify as modify,'.
                'ent.post as ct,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent,'.
                DB_PREFIX.'dia_comment com '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'ent.id = com.ref_entry AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'dia.ref_account != '.$this->account['id'].' AND '.
                'com.ref_account = '.$this->account['id'].' AND '.
                'com.modify > '.$this->term.' '.
            'GROUP BY '.
                'act.id,'.
                'dia.id,'.
                'ent.id '.
            'ORDER BY '.
                'com.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $this->Assign('posts', $result);
    }

    /**
     * コミュニティ掲示板の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $sql=
            'SELECT '.
                'com.id as ref_community,'.
                'com.community as community,'.
                'tpc.id as ref_topic,'.
                'tpc.topic as topic,'.
                'tpc.modify as modify,'.
                'tpc.status as status,'.
                'tpc.post as ct '.
            'FROM '.
                DB_PREFIX.'com_topic tpc '.
                    'LEFT JOIN '.DB_PREFIX.'com_comment cmt '.
                    'ON tpc.id = cmt.ref_topic,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'com_community com,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.id = nam.ref_community AND '.
                'com.id = tpc.ref_community AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.modify > '.$this->term.' AND '.
                'nam.ref_account = '.$this->account['id'].' AND '.
                'nam.status != '.STATUS_COMMUNITY_REFUSAL.' AND '.
                'nam.status != '.STATUS_COMMUNITY_REQUEST.' '.
            'GROUP BY '.
                'com.id,'.
                'tpc.id,'.
                'nam.id '.
            'ORDER BY '.
                'tpc.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('topics', $result);

        $urls = array(
            STATUS_TOPIC_BULLETIN=> 'bbs/browse',
            STATUS_TOPIC_EVENT=>    'bbs/browse',
            STATUS_TOPIC_ITEM=>     'item/browse',
            STATUS_TOPIC_ENQUETE=>  'item/browse',
        );
        $this->Assign('com_urls', $urls);
    }

    /**
     * 友達日記の設定
     *
     * @access private
     * @return void
     */
    function set_fdiary()
    {
        if (empty($this->account['friend_number'])){
            return ;
        }
        
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'ent.regist_date as modify,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id != '.$this->account['id'] .' AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'act.id = ent.ref_account AND '.
                'ent.regist_date > '.$this->term.' AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'fri.ref_account = '.$this->account['id'] .' AND '.
                'fri.ref_friend = act.id '.
            'ORDER BY '.
                'ent.regist_date DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $this->Assign('fdiarys', $result);
    }

    /**
     * Myフォーラムの新トピック
     *
     * @access private
     * @return void
     */
    function set_forum()
    {
        $sql=
            'SELECT '.
                'id,'.
                'modify,'.
                'post,'.
                'topic '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'modify > '.$this->term.' AND '.
                'visibility != '.VISIBILITY_HIDDEN.' '.
            'ORDER BY '.
                'modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('forums', $result);
    }

    /**
     * 日記の設定
     *
     * @access private
     * @return void
     */
    function set_diary()
    {
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'ent.regist_date as modify,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'dia.ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'ent.regist_date DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('diarys', $result);
    }

    /**
     * 日記コメントの設定
     *
     * @access private
     * @return void
     */
    function set_comment()
    {
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'com.modify as modify,'.
                'ent.post as ct,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent,'.
                DB_PREFIX.'dia_comment com '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'ent.id = com.ref_entry AND '.
                'com.modify > '.$this->term.' AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'dia.ref_account = '.$this->account['id'].' '.
            'GROUP BY '.
                'act.id,'.
                'dia.id,'.
                'ent.id '.
            'ORDER BY '.
                'com.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('comments', $result);
    }

    /**
     * レビューの設定
     *
     * @access private
     * @return void
     */
    function set_review()
    {
        $sql = 
            'SELECT '.
                'itm.id as id,'.
                'itm.name as name,'.
                'rev.modify as modify '.
            'FROM '.
                DB_PREFIX.'rev_item itm,'.
                DB_PREFIX.'rev_review rev '.
            'WHERE '.
                'itm.id = rev.ref_item AND '.
                'rev.ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'rev.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('reviews', $result);
    }

    /**
     * 紹介文の設定
     *
     * @access private
     * @return void
     */
    function set_intro()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'itr.ref_friend as ref_friend,'.
                'itr.relation as relation,'.
                'itr.comment as comment,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_intro itr '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = itr.ref_friend AND '.
                'itr.ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'itr.modify '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('intros', $result);
    }
} // webapp
?>
