-- ========================================================================
-- [sqls/pgsql.sql]
-- 		PostgreSQL用テーブル定義
--      Copyright (c) 2006 Yujiro Takahashi
-- ライセンス:
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      as published by the Free Software Foundation; either version 2
--      of the License, or (at your option) any later version.
--
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
-- 問い合わせ先：
--      yujiro@rakuto.net
--      http://rakuto.net/rktSNS/
-- 更新履歴：
--      [2007/06/17] コミュニティ：トピック、イベント、記事、アンケート権限追加
--      [2007/06/17] コミュニティ：アクセス、足跡追加
--      [2007/06/16] sns_inq_inquire.emailのblob型をbytea型に修正
--      [2007/05/27] 会員携帯用自動ログインを追加
--      [2007/04/21] 問合せ内容を修正、問合せ対応を追加
--      [2007/02/02] 日記の未読コメントflagを追加
--      [2007/01/30] メッセージの添付画像(sns_fri_picture)を追加
--      [2007/01/21] お友達のお友達名簿を修正
--      [2007/01/21] お友達の招待名簿を追加
--      [2006/12/17] 作成
-- ========================================================================

-- --------------------------------------------------------
-- 
-- Binary Large OBject
-- 
CREATE SEQUENCE seq_sns_sys_blob start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_sys_blob (
  id integer DEFAULT nextval('seq_sns_sys_blob'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  origin varchar(64) NOT NULL,
  name varchar(128) NOT NULL,
  mime_type varchar(128) NOT NULL,
  uid integer NOT NULL,
  gid integer NOT NULL,
  size integer NOT NULL,
  buffer bytea NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE (origin)
);


-- --------------------------------------------------------
-- 
-- セッション管理
-- 
CREATE TABLE sns_sys_sessions (
  id varchar(128) NOT NULL,
  life_time integer,
  sess_data text,
  PRIMARY KEY (id)
);

-- 
-- メール設定
-- 
CREATE SEQUENCE seq_sns_sys_mail start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_sys_mail (
  id integer DEFAULT nextval('seq_sns_sys_mail'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  status integer NOT NULL,
  mailing integer NOT NULL,
  from_mail varchar(128) NOT NULL,
  from_name varchar(128) NOT NULL,
  subject varchar(255) NOT NULL,
  body text NOT NULL,
  condition text,
  PRIMARY KEY  (id)
);

-- 
-- 返信メールのテンプレート設定
-- 
CREATE SEQUENCE seq_sns_sys_mailtpl start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_sys_mailtpl (
  id integer DEFAULT nextval('seq_sns_sys_mailtpl'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  code varchar(128) NOT NULL,
  subject varchar(128) NOT NULL,
  email varchar(128) NOT NULL,
  name varchar(128) NOT NULL,
  body text NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE (code)
);

-- 
-- 各種一覧のソート設定
-- 
CREATE SEQUENCE seq_sns_sys_sort start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_sys_sort (
  id integer DEFAULT nextval('seq_sns_sys_sort'::text) NOT NULL,
  ref_category integer NOT NULL,
  sort integer NOT NULL,
  label varchar(64) NOT NULL,
  direction varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- スポンサー設定
-- 
CREATE SEQUENCE seq_sns_sys_sponsor start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_sys_sponsor (
  id integer DEFAULT nextval('seq_sns_sys_sponsor'::text) NOT NULL,
  avail integer NOT NULL,
  position integer NOT NULL,
  sponsor varchar(128) NOT NULL,
  html text NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- システムデザイン
-- 
CREATE SEQUENCE seq_sns_sys_design start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_sys_design (
  id integer DEFAULT nextval('seq_sns_sys_design'::text) NOT NULL,
  ref_common integer NOT NULL,
  ref_admin integer NOT NULL,
  ref_private integer NOT NULL,
  ref_friend integer NOT NULL,
  ref_community integer NOT NULL,
  ref_public integer NOT NULL,
  frame_width integer NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- デザインテーマ
-- 
CREATE SEQUENCE seq_sns_des_theme start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_des_theme (
  id integer DEFAULT nextval('seq_sns_des_theme'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  theme varchar(128) NOT NULL,
  round varchar(6) NOT NULL,
  box varchar(6) NOT NULL,
  border varchar(6) NOT NULL,
  text varchar(6) NOT NULL,
  column varchar(6) NOT NULL,
  button varchar(6) NOT NULL,
  focus varchar(6) NOT NULL,
  header varchar(6) NOT NULL,
  background varchar(6) NOT NULL,
  PRIMARY KEY  (id)
);

-- --------------------------------------------------------
-- 
-- 地域情報
-- 
CREATE SEQUENCE seq_sns_ara_area start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_ara_area (
  id integer DEFAULT nextval('seq_sns_ara_area'::text) NOT NULL,
  sort integer NOT NULL,
  area varchar(32) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- 都道府県マスター情報
-- 
CREATE SEQUENCE seq_sns_ara_prefecture start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_ara_prefecture (
  id integer DEFAULT nextval('seq_sns_ara_prefecture'::text) NOT NULL,
  ref_area integer NOT NULL,
  sort integer NOT NULL,
  prefecture varchar(16) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- 市区町村情報
-- 
CREATE SEQUENCE seq_sns_ara_local start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_ara_local (
  id integer DEFAULT nextval('seq_sns_ara_local'::text) NOT NULL,
  ref_prefecture integer NOT NULL,
  sort integer NOT NULL,
  local varchar(64) NOT NULL,
  PRIMARY KEY  (id)
);

-- --------------------------------------------------------
-- 
-- 会員アカウント情報
-- 
CREATE SEQUENCE seq_sns_act_account start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_account (
  id integer DEFAULT nextval('seq_sns_act_account'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  last_login timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  avail integer,
  status integer NOT NULL,
  password varchar(32) NOT NULL,
  email bytea NOT NULL,
  email_hash varchar(32),
  cellular bytea,
  cellular_hash varchar(32),
  news integer,
  mailing integer,
  footprint integer DEFAULT 0,
  total integer DEFAULT 0,
  friend_number integer DEFAULT 0,
  block text,
  PRIMARY KEY  (id),
  UNIQUE (email_hash),
  UNIQUE (cellular_hash)
);

-- 
-- 会員自動ログイン
-- 
CREATE SEQUENCE seq_sns_act_autologin start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_autologin (
  id integer DEFAULT nextval('seq_sns_act_autologin'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  loginkey varchar(32),
  PRIMARY KEY  (id),
  UNIQUE (loginkey)
);

-- 
-- 会員携帯用自動ログイン
-- 
CREATE SEQUENCE seq_sns_act_mobilelogin start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_mobilelogin (
  id integer DEFAULT nextval('seq_sns_act_mobilelogin'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  agent_type integer NOT NULL,
  loginkey varchar(32),
  PRIMARY KEY  (id),
  UNIQUE (agent_type, loginkey)
);

-- 
-- 会員退会情報
-- 
CREATE SEQUENCE seq_sns_act_exit start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_exit (
  id integer DEFAULT nextval('seq_sns_act_exit'::text) NOT NULL,
  ref_account integer NOT NULL,
  modify timestamp without time zone NOT NULL,
  reason text,
  PRIMARY KEY  (id)
);

-- 
-- 血液型マスター情報
-- 
CREATE TABLE sns_act_blood (
  id integer DEFAULT nextval('sns_act_blood'::text) NOT NULL,
  sort integer NOT NULL,
  blood varchar(16) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- 結婚マスター情報
-- 
CREATE TABLE sns_act_married (
  id integer DEFAULT nextval('sns_act_married'::text) NOT NULL,
  sort integer NOT NULL,
  married varchar(64) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- 性別マスター情報
-- 
CREATE TABLE sns_act_sex (
  id integer DEFAULT nextval('sns_act_sex'::text) NOT NULL,
  sort integer NOT NULL,
  sex varchar(16) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- 会員プロフィール
-- 
CREATE SEQUENCE seq_sns_act_profile start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_profile (
  id integer DEFAULT nextval('seq_sns_act_profile'::text) NOT NULL,
  ref_account integer NOT NULL,
  modify timestamp without time zone NOT NULL,
  first_name bytea NOT NULL,
  second_name bytea NOT NULL,
  name_flag integer NOT NULL,
  nickname varchar(128) NOT NULL,
  visibility integer NOT NULL,
  ref_prefecture integer NOT NULL,
  ref_local integer,
  prefecture_flag integer NOT NULL,
  ref_sex integer NOT NULL,
  sex_flag integer NOT NULL,
  ref_blood integer NOT NULL,
  blood_flag integer NOT NULL,
  birthday date NOT NULL,
  birthday_flag integer NOT NULL,
  age_flag integer NOT NULL,
  ref_married integer NOT NULL,
  married_flag integer,
  ref_hometown integer,
  ref_homelocal integer,
  hometown_flag integer,
  publicity text,
  PRIMARY KEY  (id)
);

-- 
-- 会員アンケート
-- 
CREATE SEQUENCE seq_sns_act_enquete start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_enquete (
  id integer DEFAULT nextval('seq_sns_act_enquete'::text) NOT NULL,
  required integer NOT NULL,
  visibility integer NOT NULL,
  form_type integer NOT NULL,
  validate  varchar(32) NOT NULL,
  format  varchar(64),
  max_length integer,
  min_length integer,
  sort integer NOT NULL,
  enquete varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- アンケート項目
-- 
CREATE SEQUENCE seq_sns_act_item start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_item (
  id integer DEFAULT nextval('seq_sns_act_item'::text) NOT NULL,
  ref_enquete integer NOT NULL,
  sort integer NOT NULL,
  item varchar(255) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- アンケートの入力内容
-- 
CREATE SEQUENCE seq_sns_act_content start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_content (
  id integer DEFAULT nextval('seq_sns_act_content'::text) NOT NULL,
  ref_enquete integer NOT NULL,
  ref_item integer NOT NULL,
  ref_account integer NOT NULL,
  visibility integer,
  content text,
  PRIMARY KEY  (id),
  UNIQUE (ref_enquete,ref_item,ref_account)
);

-- 
-- アンケートの選択
-- 
CREATE SEQUENCE seq_sns_act_select start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_select (
  ref_enquete integer NOT NULL,
  ref_item integer NOT NULL,
  ref_account integer NOT NULL,
  visibility integer,
  UNIQUE (ref_enquete,ref_item,ref_account)
);

-- 
-- 会員写真
-- 
CREATE SEQUENCE seq_sns_act_photo start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_act_photo (
  id integer DEFAULT nextval('seq_sns_act_photo'::text) NOT NULL,
  ref_account integer NOT NULL,
  modify timestamp without time zone NOT NULL,
  status integer,
  subject varchar(255),
  filename varchar(255),
  width integer,
  height integer,
  thumbnail varchar(255),
  t_width integer,
  t_height integer,
  PRIMARY KEY  (id)
);

-- --------------------------------------------------------
-- 
-- カレンダースケジュール
-- 
CREATE SEQUENCE seq_sns_cal_schedule start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_cal_schedule (
  id integer DEFAULT nextval('seq_sns_cal_schedule'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  schedule varchar(255) NOT NULL,
  start_date date,
  end_date date,
  start_hour varchar(4),
  start_minute varchar(4),
  end_hour varchar(4),
  end_minute varchar(4),
  comment text,
  mail_flag integer,
  PRIMARY KEY  (id)
);


-- --------------------------------------------------------
-- 
-- 日記基礎情報
-- 
CREATE SEQUENCE seq_sns_dia_diary start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_dia_diary (
  id integer DEFAULT nextval('seq_sns_dia_diary'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  visibility integer,
  type integer,
  url varchar(255),
  rss varchar(255),
  PRIMARY KEY  (id)
);

-- 
-- 日記の投稿記事
-- 
CREATE SEQUENCE seq_sns_dia_entry start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_dia_entry (
  id integer DEFAULT nextval('seq_sns_dia_entry'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_diary integer NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  visibility integer NOT NULL,
  format integer NOT NULL,
  post integer DEFAULT 0,
  link varchar(255),
  subject varchar(255) NOT NULL,
  body text NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE (ref_diary,link)
);

-- 
-- 日記カテゴリ
-- 
CREATE SEQUENCE seq_sns_dia_category start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_dia_category (
  id integer DEFAULT nextval('seq_sns_dia_category'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_diary integer NOT NULL,
  ref_account integer NOT NULL,
  sort integer NOT NULL,
  category varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- 日記カテゴリ選択
-- 
CREATE SEQUENCE seq_sns_dia_select start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_dia_select (
  ref_diary integer NOT NULL,
  ref_category integer NOT NULL,
  ref_entry integer NOT NULL,
  UNIQUE (ref_diary,ref_category,ref_entry)
);

-- 
-- 日記へのコメント
-- 
CREATE SEQUENCE seq_sns_dia_comment start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_dia_comment (
  id integer DEFAULT nextval('seq_sns_dia_comment'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_diary integer NOT NULL,
  ref_entry integer NOT NULL,
  ref_account integer,
  flag integer default 1,
  subject varchar(255) NOT NULL,
  body text NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- 日記の添付画像
-- 
CREATE SEQUENCE seq_sns_dia_picture start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_dia_picture (
  id integer DEFAULT nextval('seq_sns_dia_picture'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  ref_entry integer,
  title varchar(255),
  filename varchar(255),
  width integer,
  height integer,
  thumbnail varchar(255),
  t_width integer,
  t_height integer,
  PRIMARY KEY  (id)
);

-- 
-- 色パレット
-- 
CREATE SEQUENCE seq_sns_dia_color start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_dia_color (
  id integer DEFAULT nextval('seq_sns_dia_color'::text) NOT NULL,
  color varchar(32),
  rgb varchar(6),
  PRIMARY KEY  (id)
);

-- 
-- フォント
-- 
CREATE SEQUENCE seq_sns_dia_font start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_dia_font (
  id integer DEFAULT nextval('seq_sns_dia_font'::text) NOT NULL,
  font varchar(32),
  label varchar(64),
  PRIMARY KEY  (id)
);

-- 
-- 本・印刷
-- 
CREATE SEQUENCE seq_sns_dia_book start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_dia_book (
  id integer DEFAULT nextval('seq_sns_dia_book'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_diary integer NOT NULL,
  ref_account integer NOT NULL,
  ref_font integer NOT NULL,
  ref_subject_color integer NOT NULL,
  ref_body_color integer NOT NULL,
  ref_line_color integer NOT NULL,
  start_date date,
  end_date date,
  comment_flag integer NOT NULL,
  created integer default 0,
  subject varchar(255) NOT NULL,
  comment text,
  PRIMARY KEY  (id)
);

-- 
-- 本カテゴリ選択
-- 
CREATE TABLE sns_dia_bookselect (
  ref_diary integer NOT NULL,
  ref_category integer NOT NULL,
  ref_book integer NOT NULL,
  UNIQUE (ref_diary,ref_category,ref_book)
);

-- --------------------------------------------------------
-- 
-- お友達のお友達名簿
-- 
CREATE SEQUENCE seq_sns_fri_friends start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_fri_friends (
  id integer DEFAULT nextval('seq_sns_fri_friends'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  avail integer,
  status integer NOT NULL,
  ref_account integer NOT NULL,
  ref_friend integer NOT NULL,
  comment text,
  PRIMARY KEY  (id),
  UNIQUE (ref_account,ref_friend)
);

-- 
-- お友達の招待名簿
-- 
CREATE SEQUENCE seq_sns_fri_invite start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_fri_invite (
  id integer DEFAULT nextval('seq_sns_fri_invite'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  ref_friend integer,
  email bytea NOT NULL,
  email_hash varchar(32),
  comment text,
  PRIMARY KEY  (id),
  UNIQUE (email_hash)
);

-- 
-- お友達のアクセスログ
-- 
CREATE SEQUENCE seq_sns_fri_accesslog start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_fri_accesslog (
  id integer DEFAULT nextval('seq_sns_fri_accesslog'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  ref_friend integer NOT NULL,
  unique_flag integer NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- お友達の足跡
-- 
CREATE SEQUENCE seq_sns_fri_footprint start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_fri_footprint (
  id integer DEFAULT nextval('seq_sns_fri_footprint'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  ref_friend integer NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- お友達のお気に入り
-- 
CREATE SEQUENCE seq_sns_fri_favorite start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_fri_favorite (
  id integer DEFAULT nextval('seq_sns_fri_favorite'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  ref_friend integer NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE (ref_account,ref_friend)
);

-- 
-- お友達の紹介
-- 
CREATE SEQUENCE seq_sns_fri_intro start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_fri_intro (
  id integer DEFAULT nextval('seq_sns_fri_intro'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  ref_friend integer NOT NULL,
  relation varchar(128),
  comment text,
  PRIMARY KEY  (id),
  UNIQUE (ref_account,ref_friend)
);

-- 
-- お友達からのメッセージ
-- 
CREATE SEQUENCE seq_sns_fri_message start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_fri_message (
  id integer DEFAULT nextval('seq_sns_fri_message'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  status integer,
  ref_account integer NOT NULL,
  ref_to integer NOT NULL,
  ref_from integer NOT NULL,
  ref_message integer,
  flag integer,
  subject varchar(128) NOT NULL,
  body text NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- メッセージの添付画像
-- 
CREATE SEQUENCE seq_sns_fri_picture start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_fri_picture (
  id integer DEFAULT nextval('seq_sns_fri_picture'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  ref_message integer,
  title varchar(255),
  filename varchar(255),
  width integer,
  height integer,
  thumbnail varchar(255),
  t_width integer,
  t_height integer,
  PRIMARY KEY  (id)
);

-- --------------------------------------------------------
-- 
-- フォーラムトピック
-- 
CREATE SEQUENCE seq_sns_frm_topic start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_frm_topic (
  id integer DEFAULT nextval('seq_sns_frm_topic'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  visibility integer,
  deadline date,
  ref_prefecture integer,
  ref_sex integer,
  ref_blood integer,
  low_age integer,
  high_age integer,
  ref_married integer,
  ref_hometown integer,
  post integer DEFAULT 0,
  topic varchar(255) NOT NULL,
  comment text NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- フォーラムのジャンル
-- 
CREATE SEQUENCE seq_sns_frm_genre start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_frm_genre (
  id integer DEFAULT nextval('seq_sns_frm_genre'::text) NOT NULL,
  sort integer NOT NULL,
  genre varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- フォーラムのカテゴリ
-- 
CREATE SEQUENCE seq_sns_frm_category start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_frm_category (
  id integer DEFAULT nextval('seq_sns_frm_category'::text) NOT NULL,
  ref_genre integer NOT NULL,
  sort integer NOT NULL,
  category varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- フォーラムの選択内容
-- 
CREATE TABLE sns_frm_select (
  ref_topic integer NOT NULL,
  ref_category integer NOT NULL,
  number integer,
  UNIQUE (ref_topic,ref_category)
);

-- 
-- フォーラムコメント
-- 
CREATE SEQUENCE seq_sns_frm_comment start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_frm_comment (
  id integer DEFAULT nextval('seq_sns_frm_comment'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_topic integer NOT NULL,
  ref_account integer NOT NULL,
  comment text NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- フォーラムのコメント返信
-- 
CREATE SEQUENCE seq_sns_frm_response start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_frm_response (
  id integer DEFAULT nextval('seq_sns_frm_response'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_topic integer NOT NULL,
  ref_comment integer NOT NULL,
  ref_account integer NOT NULL,
  point integer,
  comment text NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE (ref_topic,ref_comment,ref_account)
);

-- 
-- フォーラム用画像
-- 
CREATE SEQUENCE seq_sns_frm_picture start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_frm_picture (
  id integer DEFAULT nextval('seq_sns_frm_picture'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  ref_relation integer,
  status integer,
  title varchar(255),
  filename varchar(255),
  width integer,
  height integer,
  thumbnail varchar(255),
  t_width integer,
  t_height integer,
  PRIMARY KEY  (id)
);


-- --------------------------------------------------------
-- 
-- コミュニティのジャンル
-- 
CREATE SEQUENCE seq_sns_com_genre start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_genre (
  id integer DEFAULT nextval('seq_sns_com_genre'::text) NOT NULL,
  sort integer NOT NULL,
  genre varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- コミュニティのカテゴリ
-- 
CREATE SEQUENCE seq_sns_com_category start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_category (
  id integer DEFAULT nextval('seq_sns_com_category'::text) NOT NULL,
  ref_genre integer NOT NULL,
  sort integer NOT NULL,
  category varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- コミュニティの情報
-- 
CREATE SEQUENCE seq_sns_com_community start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_community (
  id integer DEFAULT nextval('seq_sns_com_community'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  avail integer,
  visibility integer NOT NULL,
  topic_flag integer NOT NULL,
  event_flag integer NOT NULL,
  item_flag integer NOT NULL,
  enquete_flag integer NOT NULL,
  community varchar(128) NOT NULL,
  ref_prefecture integer NOT NULL,
  url varchar(128),
  publicity text NOT NULL,
  total integer,
  access_num integer,
  PRIMARY KEY  (id)
);

-- 
-- 選択カテゴリ
-- 
CREATE TABLE sns_com_select (
  ref_category integer NOT NULL,
  ref_community integer NOT NULL,
  UNIQUE (ref_category,ref_community)
);

-- 
-- コミュニティの名簿
-- 
CREATE SEQUENCE seq_sns_com_names start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_names (
  id integer DEFAULT nextval('seq_sns_com_names'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_community integer NOT NULL,
  ref_account integer NOT NULL,
  status integer,
  comment text,
  PRIMARY KEY  (id)
);

-- 
-- コミュニティのトピック
-- 
CREATE SEQUENCE seq_sns_com_topic start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_topic (
  id integer DEFAULT nextval('seq_sns_com_topic'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_community integer NOT NULL,
  start_date date NOT NULL,
  deadline date,
  start_hour varchar(4),
  start_minute varchar(4),
  status integer,
  ref_account integer NOT NULL,
  ref_prefecture integer NOT NULL,
  ref_local integer,
  sub_locale varchar(255),
  topic varchar(255) NOT NULL,
  comment text NOT NULL,
  post integer DEFAULT 0,
  PRIMARY KEY  (id)
);

-- 
-- コミュニティのコメント
-- 
CREATE SEQUENCE seq_sns_com_comment start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_comment (
  id integer DEFAULT nextval('seq_sns_com_comment'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_community integer NOT NULL,
  ref_topic integer NOT NULL,
  ref_account integer NOT NULL,
  comment text NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- コミュニティのイベント参加
-- 
CREATE SEQUENCE seq_sns_com_entry start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_entry (
  id integer DEFAULT nextval('seq_sns_com_entry'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_community integer NOT NULL,
  ref_topic integer NOT NULL,
  ref_account integer NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE (ref_community,ref_topic,ref_account)
);

-- 
-- アンケートオプション
-- 
CREATE SEQUENCE seq_sns_com_option start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_option (
  id integer DEFAULT nextval('seq_sns_com_option'::text) NOT NULL,
  ref_community integer NOT NULL,
  ref_topic integer NOT NULL,
  sort integer NOT NULL,
  item varchar(255) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- アンケートの選択結果
-- 
CREATE SEQUENCE seq_sns_com_itmselect start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_itmselect (
  id integer DEFAULT nextval('seq_sns_com_itmselect'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_community integer NOT NULL,
  ref_topic integer NOT NULL,
  ref_account integer NOT NULL,
  ref_option integer NOT NULL,
  comment text,
  PRIMARY KEY  (id),
  UNIQUE (ref_topic,ref_account,ref_option)
);

-- 
-- コミュニティの画像
-- 
CREATE SEQUENCE seq_sns_com_picture start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_picture (
  id integer DEFAULT nextval('seq_sns_com_picture'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_community integer,
  ref_account integer NOT NULL,
  ref_relation integer,
  status integer,
  title varchar(255),
  filename varchar(255),
  width integer,
  height integer,
  thumbnail varchar(255),
  t_width integer,
  t_height integer,
  PRIMARY KEY  (id)
);

-- 
-- コミュニティのアクセスログ
-- 
CREATE SEQUENCE seq_sns_com_accesslog start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_accesslog (
  id integer DEFAULT nextval('seq_sns_com_accesslog'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_community integer NOT NULL,
  ref_account integer NOT NULL,
  unique_flag integer NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- コミュニティへの足跡
-- 
CREATE SEQUENCE seq_sns_com_footprint start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_com_footprint (
  id integer DEFAULT nextval('seq_sns_com_footprint'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_community integer NOT NULL,
  ref_account integer NOT NULL,
  PRIMARY KEY  (id)
);

-- --------------------------------------------------------
-- 
-- 問合せカテゴリのマスター情報
-- 
CREATE SEQUENCE seq_sns_inq_category start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_inq_category (
  id integer DEFAULT nextval('seq_sns_inq_category'::text) NOT NULL,
  sort integer NOT NULL,
  category varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- 問合せ内容
-- 
CREATE SEQUENCE seq_sns_inq_inquire start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_inq_inquire (
  id integer DEFAULT nextval('seq_sns_inq_inquire'::text) NOT NULL,
  modify timestamp NOT NULL,
  regist_date timestamp NOT NULL,
  ref_category integer,
  ref_account integer,
  status integer NOT NULL,
  flag integer default 0,
  name varchar(128) NOT NULL,
  url varchar(128),
  email bytea,
  comment text NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- 問合せ対応
-- 
CREATE SEQUENCE seq_sns_inq_response start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_inq_response (
  id integer DEFAULT nextval('seq_sns_inq_response'::text) NOT NULL,
  modify timestamp NOT NULL,
  regist_date timestamp NOT NULL,
  ref_inquire integer,
  ref_account integer NOT NULL,
  send integer,
  subject varchar(255) NOT NULL,
  body text NOT NULL,
  PRIMARY KEY  (id)
);



-- --------------------------------------------------------
-- 
-- システムからの記事　カテゴリマスター情報
-- 
CREATE SEQUENCE seq_sns_itm_category start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_itm_category (
  id integer DEFAULT nextval('seq_sns_itm_category'::text) NOT NULL,
  category varchar(128) NOT NULL,
  sort integer,
  PRIMARY KEY  (id)
);

-- 
-- システムからの記事
-- 
CREATE SEQUENCE seq_sns_itm_item start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_itm_item (
  id integer DEFAULT nextval('seq_sns_itm_item'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  avail integer NOT NULL,
  ref_category integer NOT NULL,
  open_date date NOT NULL,
  close_date date,
  deadline date,
  origin varchar(64),
  subject varchar(255) NOT NULL,
  body text NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE (origin)
);

-- 
-- アンケートオプション
-- 
CREATE SEQUENCE seq_sns_itm_option start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_itm_option (
  id integer DEFAULT nextval('seq_sns_itm_option'::text) NOT NULL,
  ref_item integer NOT NULL,
  sort integer NOT NULL,
  item varchar(255) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- アンケートの選択結果
-- 
CREATE SEQUENCE seq_sns_itm_select start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_itm_select (
  id integer DEFAULT nextval('seq_sns_itm_select'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  regist_date timestamp without time zone NOT NULL,
  ref_item integer NOT NULL,
  ref_account integer NOT NULL,
  ref_option integer NOT NULL,
  comment text,
  PRIMARY KEY  (id),
  UNIQUE (ref_item,ref_account,ref_option)
);

-- 
-- システムからの記事　ファイルアップ
-- 
CREATE SEQUENCE seq_sns_itm_fileinfo start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_itm_fileinfo (
  id integer DEFAULT nextval('seq_sns_itm_fileinfo'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_category integer NOT NULL,
  subject varchar(255) NOT NULL,
  mimetype varchar(64),
  filename varchar(255),
  width integer,
  height integer,
  thumbnail varchar(255),
  t_width integer,
  t_height integer,
  PRIMARY KEY  (id)
);


-- --------------------------------------------------------
-- 
-- レビュー　カテゴリマスター情報
-- 
CREATE SEQUENCE seq_sns_rev_category start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_rev_category (
  id integer DEFAULT nextval('seq_sns_rev_category'::text) NOT NULL,
  type integer NOT NULL,
  sort integer NOT NULL,
  category varchar(128) NOT NULL,
  code varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- レビューの対象商品
-- 
CREATE SEQUENCE seq_sns_rev_item start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_rev_item (
  id integer DEFAULT nextval('seq_sns_rev_item'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_category integer NOT NULL,
  total float,
  post integer DEFAULT 0,
  url varchar(255) NOT NULL,
  asin varchar(128) NOT NULL,
  name text NOT NULL,
  creator text NOT NULL,
  release varchar(32) NOT NULL,
  manufacturer varchar(255) NOT NULL,
  imagesmall varchar(255) NOT NULL,
  imagemedium varchar(255) NOT NULL,
  imagelarge varchar(255) NOT NULL,
  listprice varchar(64) NOT NULL,
  ourprice varchar(64) NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE (asin)
);

-- 
-- レビューの結果ポイントマスター情報
-- 
CREATE SEQUENCE seq_sns_rev_point start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_rev_point (
  id integer DEFAULT nextval('seq_sns_rev_point'::text) NOT NULL,
  point integer NOT NULL,
  sort integer NOT NULL,
  label varchar(128) NOT NULL,
  PRIMARY KEY  (id)
);

-- 
-- レビュー内容
-- 
CREATE SEQUENCE seq_sns_rev_review start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;
CREATE TABLE sns_rev_review (
  id integer DEFAULT nextval('seq_sns_rev_review'::text) NOT NULL,
  modify timestamp without time zone NOT NULL,
  ref_account integer NOT NULL,
  ref_item integer NOT NULL,
  comment text,
  point integer NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE (ref_account,ref_item)
);
