<?php
/* SVN FILE: $Id: commentTime.php 578 2008-06-11 22:26:15Z bb_yujiro $ */
/**
 * コメント時間の登録
 *
 * PHP versions 5
 *
 *      Xoops ModuleのCinemaruをhitSujiプラグインに移植したものです。
 *      Xoops用の本家は http://cinemaru.jp/ を参照下さい。
 *
 * Licensed under The GNU General Public License v2
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        Plugin
 * @package         Cinemaru hitSuji Plugin
 * @copyright       Copyright (c) 2008 Cinemaru Project
 * @link            http://cinemaru.jp/
 * @author          時田正彦 <BQB04357@nifty.ne.jp>
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 578 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-12 07:26:15 +0900 (木, 12 6 2008) $
 * @license         http://www.gnu.org/licenses/gpl-2.0.txt The GPLv2
 */

/**
 * コメント時間の表示
 *
 * @access public
 * @param integer   $timestamp
 * @return void
 **/
function cinemaru_commentTime($timestamp)
{
    $time = intval($timestamp / 1000);
    $hour = $time / 3600;
    $min  = $time / 60;
    $sec  = $time % 60;
    printf('%02d:%02d:%02d', $hour, $min, $sec);
} // hitsuji_commentTime
?>
