<?php
/* SVN FILE: $Id: cinemaru_comment.php 578 2008-06-11 22:26:15Z bb_yujiro $ */
/**
 * cinemaru_commentテーブルクラス
 *
 * PHP versions 5
 *
 *      Xoops ModuleのCinemaruをhitSujiプラグインに移植したものです。
 *      Xoops用の本家は http://cinemaru.jp/ を参照下さい。
 *
 * Licensed under The GNU General Public License v2
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        Plugin
 * @package         Cinemaru hitSuji Plugin
 * @copyright       Copyright (c) 2008 Cinemaru Project
 * @link            http://cinemaru.jp/
 * @author          時田正彦 <BQB04357@nifty.ne.jp>
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 578 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-12 07:26:15 +0900 (木, 12 6 2008) $
 * @license         http://www.gnu.org/licenses/gpl-2.0.txt The GPLv2
 */

/**
 * cinemaru_commentテーブルクラス
 *
 * @category        Plugin
 * @package         Cinemaru hitSuji Plugin
 * @copyright       Copyright (c) 2008 Cinemaru Project
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 578 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-12 07:26:15 +0900 (木, 12 6 2008) $
 * @license         http://www.gnu.org/licenses/gpl-2.0.txt The GPLv2
 */
class cinemaru_comment extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * ref_movie 
     * @var number 
     */
    public $ref_movie = null;

    /**
     * ref_author 
     * @var number 
     */
    public $ref_author = null;

    /**
     * comment_time 
     * @var number 
     */
    public $comment_time = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'cinemaru_comment';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_movie'=> array(
            'column'=>    'ref_movie',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'cinemaru_movie',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_author'=> array(
            'column'=>    'ref_author',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'comment_time'=> array(
            'column'=>    'comment_time',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,ref_movie,ref_author,comment_time,comment';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:ref_movie,:ref_author,:comment_time,:comment';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, ref_movie=:ref_movie, ref_author=:ref_author, comment_time=:comment_time, comment=:comment';
    /* <<<<<end */

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        /* カウント */
        $condition = array(
            'ref_movie'=> $this->ref_movie
        );
        $row = RKT_DB::getRow($this->tbl_name, $condition, 'count(*) as ct');
        $count = empty($row['ct'])? 0:$row['ct'];

        /* 投稿カウント */
        $sql = 'UPDATE '.DB_PREFIX.'cinemaru_movie '.
                   'SET posts = '.$count.' '.
               'WHERE id = '.$this->ref_movie;
        $this->objdb->exec($sql);
    }
} // class cinemaru_comment
?>
