<?php
/* SVN FILE: $Id: cinemaru_movie.php 578 2008-06-11 22:26:15Z bb_yujiro $ */
/**
 * cinemaru_movieテーブルクラス
 *
 * PHP versions 5
 *
 *      Xoops ModuleのCinemaruをhitSujiプラグインに移植したものです。
 *      Xoops用の本家は http://cinemaru.jp/ を参照下さい。
 *
 * Licensed under The GNU General Public License v2
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        Plugin
 * @package         Cinemaru hitSuji Plugin
 * @copyright       Copyright (c) 2008 Cinemaru Project
 * @link            http://cinemaru.jp/
 * @author          時田正彦 <BQB04357@nifty.ne.jp>
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 578 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-12 07:26:15 +0900 (木, 12 6 2008) $
 * @license         http://www.gnu.org/licenses/gpl-2.0.txt The GPLv2
 */

/**
 * cinemaru_movieテーブルクラス
 *
 * @category        Plugin
 * @package         Cinemaru hitSuji Plugin
 * @copyright       Copyright (c) 2008 Cinemaru Project
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 578 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-12 07:26:15 +0900 (木, 12 6 2008) $
 * @license         http://www.gnu.org/licenses/gpl-2.0.txt The GPLv2
 */
class cinemaru_movie extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * regist_date 
     * @var date 
     */
    public $regist_date = null;

    /**
     * movie 
     * @var string 
     */
    public $movie = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * file_url 
     * @var uri 
     */
    public $file_url = null;

    /**
     * image_url 
     * @var uri 
     */
    public $image_url = null;

    /**
     * total_time 
     * @var number 
     */
    public $total_time = null;

    /**
     * file_type 
     * @var number 
     */
    public $file_type = null;

    /**
     * file_size 
     * @var number 
     */
    public $file_size = null;

    /**
     * randam_code 
     * @var string 
     */
    public $randam_code = null;

    /**
     * posts 
     * @var number 
     */
    public $posts = null;

    /**
     * counter 
     * @var number 
     */
    public $counter = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'cinemaru_movie';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'regist_date'=> array(
            'column'=>    'regist_date',
            'type'=>      'date',
            'default'=>   '0000-00-00 00:00:00',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'movie'=> array(
            'column'=>    'movie',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'file_url'=> array(
            'column'=>    'file_url',
            'type'=>      'uri',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'image_url'=> array(
            'column'=>    'image_url',
            'type'=>      'uri',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'total_time'=> array(
            'column'=>    'total_time',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'file_type'=> array(
            'column'=>    'file_type',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'file_size'=> array(
            'column'=>    'file_size',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'randam_code'=> array(
            'column'=>    'randam_code',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'posts'=> array(
            'column'=>    'posts',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'counter'=> array(
            'column'=>    'counter',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,regist_date,movie,ref_account,file_url,image_url,total_time,file_type,file_size,randam_code,posts,counter,comment';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:regist_date,:movie,:ref_account,:file_url,:image_url,:total_time,:file_type,:file_size,:randam_code,:posts,:counter,:comment';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, regist_date=:regist_date, movie=:movie, ref_account=:ref_account, file_url=:file_url, image_url=:image_url, total_time=:total_time, file_type=:file_type, file_size=:file_size, randam_code=:randam_code, posts=:posts, counter=:counter, comment=:comment';
    /* <<<<<end */

    /**
     * 閲覧カウンター
     *
     * @access public
     */
    public function viewCounter()
    {
        /* カウント */
        $count = empty($this->old_values['counter'])? 1:$this->old_values['counter'] + 1;

        /* 閲覧カウント */
        $sql = 'UPDATE '.DB_PREFIX.$this->tbl_name.' '.
                   'SET counter = '.$count.' '.
               'WHERE id = '.$this->cur_id;
        $this->objdb->exec($sql);
    }
} // class cinemaru_movie
?>
