/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.robotbrain.signal.Tag;

public class UtilFramework {
    private static ReentrantLock m_lock = new ReentrantLock();

    private UtilFramework() {
    }

    public static int random(int p_max) {
        if (p_max < 0) {
            throw new RuntimeException();
        }
        double r = Math.random() * (double)(p_max + 1);
        r = Math.floor(r);
        return (int)r;
    }

    public static boolean probability(double p_odds) {
        double r;
        if (p_odds < 0.0) {
            p_odds = 0.0;
        }
        if (p_odds > 1.0) {
            p_odds = 1.0;
        }
        return p_odds > (r = Math.random());
    }

    public static double roundDouble(double p_value, int p_scale) {
        BigDecimal bd = new BigDecimal(String.valueOf(p_value));
        double returnValue = bd.setScale(p_scale, 4).doubleValue();
        return returnValue;
    }

    public static String formatDouble(double p_value, int p_scale) {
        String pattern = "";
        if (p_scale <= 0) {
            pattern = "#";
        } else {
            pattern = "#.";
            int i = 0;
            while (i < p_scale) {
                pattern = String.valueOf(pattern) + "#";
                ++i;
            }
        }
        DecimalFormat fmt = new DecimalFormat(pattern);
        return fmt.format(p_value);
    }

    public static void putObjectFile(String p_filePath, Object p_object) throws IOException {
        try {
            m_lock.lock();
            FileOutputStream outFile = new FileOutputStream(p_filePath);
            ObjectOutputStream outObject = new ObjectOutputStream(outFile);
            outObject.writeObject(p_object);
            outObject.close();
            outFile.close();
        }
        finally {
            m_lock.unlock();
        }
    }

    public static Object readObjectFile(String p_filePath) throws IOException, ClassNotFoundException {
        try {
            m_lock.lock();
            FileInputStream inFile = new FileInputStream(p_filePath);
            ObjectInputStream inObject = new ObjectInputStream(inFile);
            Object returnValue = inObject.readObject();
            inObject.close();
            inFile.close();
            Object object = returnValue;
            return object;
        }
        finally {
            m_lock.unlock();
        }
    }

    public static String findStringByRegex(String p_src, String p_regex, int p_seq) {
        String returnValue = "";
        Pattern p = Pattern.compile(p_regex, 32);
        Matcher m = p.matcher(p_src);
        if (m.find()) {
            returnValue = m.group(p_seq);
        }
        return returnValue;
    }

    public static int parseInt(String p_src) throws NumberFormatException {
        String s = p_src.replaceAll(",", "");
        s = s.replaceAll("\r", "");
        s = s.replaceAll("\n", "");
        int returnValue = Integer.parseInt(s.trim());
        return returnValue;
    }

    public static double parseDouble(String p_src) throws NumberFormatException {
        String s = p_src.replaceAll(",", "");
        s = s.replaceAll("\r", "");
        s = s.replaceAll("\n", "");
        double returnValue = Double.parseDouble(s.trim());
        return returnValue;
    }

    public static long calcTagTimeDifference(Tag p_tagA, Tag p_tagB) {
        Calendar a = p_tagA.getCalendar();
        Calendar b = p_tagB.getCalendar();
        return Math.abs(a.getTimeInMillis() - b.getTimeInMillis()) / 1000L;
    }

    public static boolean isExistsFile(String p_path) {
        try {
            m_lock.lock();
            File f = new File(p_path);
            return f.exists();
            {
            }
        }
        finally {
            m_lock.unlock();
        }
    }

    public static boolean createFolders(String p_folderPath) {
        try {
            m_lock.lock();
            File f = new File(p_folderPath);
            if (!f.exists()) {
                boolean bl = f.mkdirs();
                return bl;
            }
            return true;
        }
        finally {
            m_lock.unlock();
        }
    }
}

