/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.html;

import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import jp.robotbrain.html.HtmlFormException;
import jp.robotbrain.html.HtmlInput;

public class HtmlInputList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<HtmlInput> m_htmlInputList = new ArrayList();

    protected void add(HtmlInput p_htmlInput) {
        if (this.m_htmlInputList.indexOf(p_htmlInput) == -1) {
            this.m_htmlInputList.add(p_htmlInput);
        }
    }

    public boolean isExistHtmlInputByName(String p_name) {
        if (this.m_htmlInputList.size() <= 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            if (htmlInput.getName().equals(p_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public HtmlInput getHtmlInputByName(String p_name) throws HtmlFormException {
        if (this.m_htmlInputList.size() <= 0) {
            throw new HtmlFormException("method:HtmlInputList.getHtmlInputByName size=0");
        }
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            if (htmlInput.getName().equals(p_name)) {
                if (htmlInput.getType().equals("radio")) {
                    if (htmlInput.isSelected()) {
                        return htmlInput;
                    }
                } else {
                    return htmlInput;
                }
            }
            ++i;
        }
        throw new HtmlFormException("method:HtmlInputList.getHtmlInputByName p_name=" + p_name);
    }

    public HtmlInput getHtmlInputById(String p_id) throws HtmlFormException {
        if (this.m_htmlInputList.size() <= 0) {
            throw new HtmlFormException("method:HtmlInputList.getHtmlInputById size=0");
        }
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            if (htmlInput.getId().equals(p_id)) {
                return htmlInput;
            }
            ++i;
        }
        throw new HtmlFormException("method:HtmlInputList.getHtmlInputById p_id=" + p_id);
    }

    public void clickSubmitByValue(String p_value) throws HtmlFormException {
        if (this.m_htmlInputList.size() <= 0) {
            throw new HtmlFormException("method:HtmlInputList.clickSubmitByValue size=0");
        }
        int count = 0;
        HtmlInput select = null;
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            if (htmlInput.getType().equals("submit") && htmlInput.getValue().equals(p_value)) {
                select = htmlInput;
                ++count;
            }
            ++i;
        }
        if (count < 1) {
            throw new HtmlFormException("method:HtmlInputList.clickSubmitByValue p_value=" + p_value + " count=" + count);
        }
        select.setSelected(true);
    }

    public void clickSubmitByName(String p_name) throws HtmlFormException {
        if (this.m_htmlInputList.size() <= 0) {
            throw new HtmlFormException("method:HtmlInputList.clickSubmitByName size=0");
        }
        int count = 0;
        HtmlInput select = null;
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            if (htmlInput.getType().equals("submit") && htmlInput.getName().equals(p_name)) {
                select = htmlInput;
                ++count;
            }
            ++i;
        }
        if (count < 1) {
            throw new HtmlFormException("method:HtmlInputList.clickSubmitByName p_name=" + p_name + " count=" + count);
        }
        select.setSelected(true);
    }

    public void clickRadioByNameAndValue(String p_name, String p_value) throws HtmlFormException {
        if (this.m_htmlInputList.size() <= 0) {
            throw new HtmlFormException("method:HtmlInputList.clickRadioByNameAndValue size=0");
        }
        int count = 0;
        HtmlInput select = null;
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            if (htmlInput.getType().equals("radio") && htmlInput.getValue().equals(p_value) && htmlInput.getName().equals(p_name)) {
                select = htmlInput;
                ++count;
            }
            ++i;
        }
        if (count != 1) {
            throw new HtmlFormException("method:HtmlInputList.clickRadioByNameAndValue p_name=" + p_name + " p_value=" + p_value + " count=" + count);
        }
        select.setSelected(true);
    }

    public void clickRadioByNameAndId(String p_name, String p_id) throws HtmlFormException {
        if (this.m_htmlInputList.size() <= 0) {
            throw new HtmlFormException("method:HtmlInputList.clickRadioByNameAndId size=0");
        }
        int count = 0;
        HtmlInput select = null;
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            if (htmlInput.getType().equals("radio") && htmlInput.getId().equals(p_id) && htmlInput.getName().equals(p_name)) {
                select = htmlInput;
                ++count;
            }
            ++i;
        }
        if (count != 1) {
            throw new HtmlFormException("method:HtmlInputList.clickRadioByNameAndId p_name=" + p_name + " p_id=" + p_id + " count=" + count);
        }
        select.setSelected(true);
    }

    public void clickFirstRadioByName(String p_name) throws HtmlFormException {
        if (this.m_htmlInputList.size() <= 0) {
            throw new HtmlFormException("method:HtmlInputList.clickFirstRadioByName size=0");
        }
        int count = 0;
        HtmlInput select = null;
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            if (htmlInput.getType().equals("radio") && htmlInput.getName().equals(p_name)) {
                select = htmlInput;
                ++count;
                break;
            }
            ++i;
        }
        if (count != 1) {
            throw new HtmlFormException("method:HtmlInputList.clickFirstRadioByName p_name=" + p_name + " count=" + count);
        }
        select.setSelected(true);
    }

    public void print(PrintStream p_out) {
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            htmlInput.print(p_out);
            ++i;
        }
    }

    protected String createQueryString(String p_charset) throws UnsupportedEncodingException {
        String returnValue = "";
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput htmlInput = this.m_htmlInputList.get(i);
            String type = htmlInput.getType();
            if (!htmlInput.getName().equals("")) {
                if (type.equals("submit") || type.equals("reset")) {
                    if (htmlInput.isSelected()) {
                        returnValue = String.valueOf(returnValue) + "&" + htmlInput.getName() + "=" + URLEncoder.encode(htmlInput.getValue(), p_charset);
                    }
                } else if (type.equals("checkbox") || type.equals("radio")) {
                    if (htmlInput.isSelected()) {
                        returnValue = htmlInput.getValue().equals("") ? String.valueOf(returnValue) + "&" + htmlInput.getName() + "=on" : String.valueOf(returnValue) + "&" + htmlInput.getName() + "=" + URLEncoder.encode(htmlInput.getValue(), p_charset);
                    }
                } else {
                    returnValue = String.valueOf(returnValue) + "&" + htmlInput.getName() + "=" + URLEncoder.encode(htmlInput.getValue(), p_charset);
                }
            }
            ++i;
        }
        return returnValue;
    }

    public boolean equalsFormat(HtmlInputList p_other) {
        if (this.m_htmlInputList.size() != p_other.m_htmlInputList.size()) {
            return false;
        }
        int i = 0;
        while (i < this.m_htmlInputList.size()) {
            HtmlInput other;
            HtmlInput me = this.m_htmlInputList.get(i);
            if (!me.equalsFormat(other = p_other.m_htmlInputList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void remove(HtmlInput p_htmlInput) {
        this.m_htmlInputList.remove(p_htmlInput);
    }
}

