/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.StdevLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="StdevLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcount"})
public class StdevLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final StdevLine m_stdevLine;

    public StdevLineStream(String p_label, GeneList p_geneList, String p_pcountLabel) throws GeneListException {
        super(p_label);
        Gene pcountGene = p_geneList.getGene(p_pcountLabel);
        int pcount = pcountGene.getIntValue();
        this.m_stdevLine = new StdevLine(pcount);
    }

    public void enter(IndexLine p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_stdevLine.size();
        this.m_stdevLine.addPoint((IndexLine)p_indexObjectList);
        if (this.m_stdevLine.size() > prevSize) {
            this.notifyIndexNext(this.m_stdevLine);
        }
    }

    public StdevLine getValues() {
        return this.m_stdevLine;
    }
}

