/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.Signal;
import jp.robotbrain.signal.SignalBlock;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeSignalBlock;

@TypeSignalBlock
@InputComponentList(values={"main@Signal", "losscut@Signal", "reverse@Signal"})
public class ReverseSwitch
extends SignalBlock {
    private NmSignal m_saveLossCutSignal = NmSignal.NOSIGNAL;

    public ReverseSwitch(String p_label, int p_priority) {
        super(p_label, p_priority);
    }

    @Override
    public JudgmentResult getJudgmentResult() throws IndexStreamException {
        Signal main = this.lookupInputSignal("main@Signal");
        Signal losscut = this.lookupInputSignal("losscut@Signal");
        Signal reverse = this.lookupInputSignal("reverse@Signal");
        Tag inputTag = this.getInputTag();
        if (inputTag == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        NmSignal returnValue = main.getJudgmentResult().getSignal();
        NmSignal losscutSignal = losscut.getJudgmentResult().getSignal();
        NmSignal reverseSignal = reverse.getJudgmentResult().getSignal();
        if (this.m_saveLossCutSignal == NmSignal.NOSIGNAL) {
            if (losscutSignal == NmSignal.ESCAPE) {
                this.m_saveLossCutSignal = returnValue;
                returnValue = NmSignal.NOSIGNAL;
            }
        } else if (reverseSignal == this.m_saveLossCutSignal) {
            this.m_saveLossCutSignal = NmSignal.NOSIGNAL;
        } else {
            returnValue = NmSignal.NOSIGNAL;
        }
        this.setDetails(returnValue.toString());
        return new JudgmentResult(inputTag, returnValue);
    }

    private Signal lookupInputSignal(String p_portLabel) throws IndexStreamException {
        for (Signal returnValue : this.getInputSignalList()) {
            if (!returnValue.isExistDestination(p_portLabel)) continue;
            return returnValue;
        }
        throw new IndexStreamException(String.valueOf(this.getLabel()) + " Not Found Input Port Label: " + p_portLabel);
    }
}

