/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.DmiList;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="DmiList")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class DmiListStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final DmiList m_dmiList;
    private int m_cost;

    public DmiListStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
        super(p_label);
        Gene ccountGene = p_geneList.getGene(p_ccountLabel);
        int ccount = ccountGene.getIntValue();
        this.m_dmiList = new DmiList(ccount);
        this.m_cost = ccount + 1;
    }

    public void enter(CandleStickList p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndexSub(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (!(p_indexObjectList instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_dmiList.addObject((CandleStickList)p_indexObjectList);
        this.notifyIndexNext(this.m_dmiList);
    }

    public DmiList getValues() {
        return this.m_dmiList;
    }

    @Override
    public int getCost() {
        return this.m_cost;
    }

    @Override
    public void economizeCapacity() {
        this.m_dmiList.setCapacity(this.getDestinationMaxCost());
    }
}

