/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.util.ArrayList;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.TradeComponent;

public abstract class Signal
extends TradeComponent {
    private final int m_priority;
    private NmSignal m_defaultSignal;
    private ArrayList<String> m_destinationList;
    private JudgmentResult m_lastJudgmentResult;

    public Signal(String p_label, int p_priority) {
        super(p_label);
        this.m_priority = p_priority;
        this.m_defaultSignal = NmSignal.NOSIGNAL;
        this.m_destinationList = new ArrayList();
    }

    public final JudgmentResult getJudgmentResult() throws IndexStreamException {
        this.m_lastJudgmentResult = this.getJudgmentResultSub();
        return this.m_lastJudgmentResult;
    }

    protected abstract JudgmentResult getJudgmentResultSub() throws IndexStreamException;

    public int getPriority() {
        return this.m_priority;
    }

    public void setDefaultSignal(NmSignal p_defaultSignal) {
        this.m_defaultSignal = p_defaultSignal;
    }

    public NmSignal getDefaultSignal() {
        return this.m_defaultSignal;
    }

    public boolean isExistDestination(String p_portLabel) {
        int idx = this.m_destinationList.indexOf(p_portLabel);
        return idx >= 0;
    }

    public void addDestination(String p_portLabel) {
        this.m_destinationList.add(p_portLabel);
    }

    public JudgmentResult getLastJudgmentResult() {
        return this.m_lastJudgmentResult;
    }

    public String toXml() {
        if (this.getLastJudgmentResult() == null) {
            return null;
        }
        if (this.getLastJudgmentResult().getTag() == null) {
            return null;
        }
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("<signal tag=\"");
        returnValue.append(this.getLastJudgmentResult().getTag().getValue());
        returnValue.append("\">");
        returnValue.append("<value>");
        returnValue.append((Object)this.getLastJudgmentResult().getSignal());
        returnValue.append("</value>");
        returnValue.append("</signal>");
        return returnValue.toString();
    }
}

