/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.ChannelLowLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="ChannelLowLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class ChannelLowLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final ChannelLowLine m_channelLowLine;

    public ChannelLowLineStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
        super(p_label);
        Gene ccountGene = p_geneList.getGene(p_ccountLabel);
        int cost = ccountGene.getIntValue();
        this.m_channelLowLine = new ChannelLowLine(cost);
        this.getPortList().add("@CandleStickList", cost);
    }

    @Override
    public void notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@CandleStickList");
        if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_channelLowLine.addPoint((CandleStickList)port.getIndexStream().getValues());
        this.notifyIndexNext();
    }

    @Override
    public ChannelLowLine getValues() {
        return this.m_channelLowLine;
    }

    @Override
    public void economizeCapacity() {
        this.m_channelLowLine.setCapacity(this.getDestinationMaxCost());
    }
}

