/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.EntryPoint;
import jp.robotbrain.signal.FrameworkParameter;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.TypeIndexStream;

@EntryPoint
@FrameworkParameter
@TypeIndexStream(value="SimpleLine")
@InputComponentList(values={"@IndexLine"})
public class SimpleLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final SimpleLine m_simpleLine = new SimpleLine();

    public SimpleLineStream(String p_label) {
        super(p_label);
        this.getPortList().add("@IndexLine", 1);
    }

    public void enter(IndexPoint p_src) throws IndexStreamException {
        if (p_src == null) {
            throw new IndexStreamException("Null Error");
        }
        this.m_simpleLine.addPoint(p_src);
        this.notifyIndexNext();
    }

    @Override
    public void notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@IndexLine");
        if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        IndexLine il = (IndexLine)port.getIndexStream().getValues();
        this.m_simpleLine.addPoint((IndexPoint)il.getLast());
        this.notifyIndexNext();
    }

    @Override
    public SimpleLine getValues() {
        return this.m_simpleLine;
    }

    @Override
    public void economizeCapacity() {
        this.m_simpleLine.setCapacity(this.getDestinationMaxCost());
    }
}

