/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.DmiList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.NmIcon;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="DmiList")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class DmiListStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final DmiList m_dmiList;

    public DmiListStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
        super(p_label, NmIcon.ZEROTO100);
        Gene ccountGene = p_geneList.getGene(p_ccountLabel);
        int ccount = ccountGene.getIntValue();
        this.m_dmiList = new DmiList(ccount);
        this.getPortList().add("@CandleStickList", ccount + 1);
    }

    public DmiListStream(String p_label, GeneList p_geneList) throws GeneListException {
        super(p_label, NmIcon.ZEROTO100);
        int ccount = 0;
        if (p_geneList.size() > 0) {
            Gene ccountGene = p_geneList.getGene(0);
            ccount = ccountGene.getIntValue();
        }
        this.m_dmiList = new DmiList(ccount);
        this.getPortList().add("@CandleStickList", ccount + 1);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@CandleStickList");
        if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_dmiList.addObject((CandleStickList)port.getIndexStream().getValues());
        return this.notifyIndexNext();
    }

    public DmiList getValues() {
        return this.m_dmiList;
    }

    public DmiList getViewValues() {
        return this.m_dmiList;
    }

    @Override
    public void economizeMemory() {
        this.m_dmiList.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_dmiList.setCapacity(capacity);
    }
}

