/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.ChannelHighLine;
import jp.robotbrain.signal.ChannelLowLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.NmIcon;
import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="SimpleLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class HighLowDifferenceLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final SimpleLine m_HighLowDifferenceLine;
    private final ChannelHighLine m_channelHighLine;
    private final ChannelLowLine m_channelLowLine;

    public HighLowDifferenceLineStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
        super(p_label, NmIcon.FILTER);
        Gene ccountGene = p_geneList.getGene(p_ccountLabel);
        int cost = ccountGene.getIntValue();
        this.m_HighLowDifferenceLine = new SimpleLine();
        this.m_channelHighLine = new ChannelHighLine(cost);
        this.m_channelLowLine = new ChannelLowLine(cost);
        this.getPortList().add("@CandleStickList", cost);
    }

    public HighLowDifferenceLineStream(String p_label, GeneList p_geneList) throws GeneListException {
        super(p_label, NmIcon.FILTER);
        int cost = 0;
        if (p_geneList.size() > 0) {
            Gene ccountGene = p_geneList.getGene(0);
            cost = ccountGene.getIntValue();
        }
        this.m_HighLowDifferenceLine = new SimpleLine();
        this.m_channelHighLine = new ChannelHighLine(cost);
        this.m_channelLowLine = new ChannelLowLine(cost);
        this.getPortList().add("@CandleStickList", cost);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@CandleStickList");
        if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_channelHighLine.addPoint((CandleStickList)port.getIndexStream().getValues());
        this.m_channelLowLine.addPoint((CandleStickList)port.getIndexStream().getValues());
        if (port.getIndexStream().getValues().size() > 0) {
            Tag tag = ((IndexObject)port.getIndexStream().getValues().getLast()).getTag();
            if (this.m_channelHighLine.size() > 0 && this.m_channelLowLine.size() > 0) {
                double high = ((IndexPoint)this.m_channelHighLine.getLast()).getValue();
                double low = ((IndexPoint)this.m_channelLowLine.getLast()).getValue();
                this.m_HighLowDifferenceLine.addPoint(new IndexPoint(tag, high - low));
            } else {
                this.m_HighLowDifferenceLine.addPoint(new IndexPoint(tag, 0));
            }
        }
        return this.notifyIndexNext();
    }

    @Override
    public SimpleLine getValues() {
        return this.m_HighLowDifferenceLine;
    }

    public SimpleLine getViewValues() {
        return this.m_HighLowDifferenceLine;
    }

    @Override
    public void economizeMemory() {
        this.m_HighLowDifferenceLine.setCapacity(this.getDestinationMaxCost());
        this.m_channelHighLine.setCapacity(this.getDestinationMaxCost());
        this.m_channelLowLine.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_HighLowDifferenceLine.setCapacity(capacity);
        this.m_channelHighLine.setCapacity(capacity);
        this.m_channelLowLine.setCapacity(capacity);
    }
}

