/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.ui.graph;

import java.awt.Color;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.UtilSignal;
import jp.robotbrain.ui.graph.GraphException;
import jp.robotbrain.ui.graph.GraphPanel;
import jp.robotbrain.ui.graph.GraphRuler;

public class GraphLayer {
    private final String m_name;
    private final int m_layerNo;
    private final int m_indexScale;
    private GraphRuler m_ruler;
    private String m_title;
    private IndexObjectList<?> m_paintSrcList;
    private double m_max;
    private double m_min;
    private int m_heightRatio;
    private Tag m_prevTag;
    private Color m_foreColor;
    private boolean m_statusColor;
    private int m_top;
    private final int m_titleBarTopOffset;
    private int m_titleBarHeight;
    private int m_indexTopOffset;
    private final int m_indexBottomOffset;
    private boolean m_syncRuler;
    private final boolean m_mainLayer;
    private final GraphPanel m_parent;
    private final IndexObjectList<?> m_srcList;
    private final int m_divCount;

    protected GraphLayer(GraphPanel p_parent, String p_name, boolean p_mainLayer, IndexObjectList<?> p_srcList, int p_layerNo, int p_divCount, int p_titleBarTopOffset, int p_indexBottomOffset) throws GraphException {
        this.m_name = p_name;
        this.m_heightRatio = 100;
        this.m_layerNo = p_layerNo;
        this.m_titleBarTopOffset = p_titleBarTopOffset;
        this.m_foreColor = Color.BLACK;
        this.m_title = "";
        this.m_syncRuler = false;
        this.m_mainLayer = p_mainLayer;
        this.m_parent = p_parent;
        this.m_divCount = p_divCount;
        this.m_indexBottomOffset = p_indexBottomOffset;
        if (p_srcList == null) {
            throw new GraphException("SrcLine is Null: " + p_name);
        }
        if (p_srcList.size() < 2) {
            throw new GraphException("Few SrcLine Values: " + p_name);
        }
        this.m_srcList = p_srcList;
        this.m_indexScale = UtilSignal.maxScale(this.m_srcList);
        this.init();
    }

    protected void init() throws GraphException {
        if (this.m_mainLayer) {
            this.initMainLayer();
        } else {
            this.initSubLayer();
        }
        this.initRuler();
    }

    protected void initRuler() {
        this.m_ruler = new GraphRuler(this);
    }

    private void initMainLayer() {
        int viewPointCount = this.m_parent.getWidthPointCount();
        if (viewPointCount > this.m_srcList.size()) {
            viewPointCount = this.m_srcList.size();
        }
        if (this.m_srcList instanceof CandleStickList) {
            CandleStickList src = (CandleStickList)this.m_srcList;
            CandleStickList srcTail = src.getTailList(viewPointCount);
            if (this.m_srcList.getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                this.m_max = 100.0;
                this.m_min = 0.0;
            } else {
                this.m_max = srcTail.getMax();
                this.m_min = srcTail.getMin();
            }
            this.m_paintSrcList = srcTail;
        } else if (this.m_srcList instanceof IndexLine) {
            IndexLine src = (IndexLine)this.m_srcList;
            IndexLine srcTail = src.getTailLine(viewPointCount);
            if (this.m_srcList.getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                this.m_max = 100.0;
                this.m_min = 0.0;
            } else {
                this.m_max = srcTail.getMax().getValue();
                this.m_min = srcTail.getMin().getValue();
            }
            this.m_paintSrcList = srcTail;
        } else {
            this.m_max = 0.0;
            this.m_min = 0.0;
            this.m_paintSrcList = this.m_srcList;
        }
    }

    private void initSubLayer() throws GraphException {
        if (this.m_parent.getMainLayer() == null) {
            throw new GraphException("Not Found MainLayer");
        }
        if (this.m_parent.getMainLayer().getPaintSrcList().size() <= 0) {
            throw new GraphException("Not Found MainLayer");
        }
        Object idx = this.m_parent.getMainLayer().getPaintSrcList().get(0);
        if (this.m_srcList instanceof CandleStickList) {
            CandleStickList src = (CandleStickList)this.m_srcList;
            CandleStickList srcTail = src.getTailList(((IndexObject)idx).getTag());
            if (this.m_srcList.getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                this.m_max = 100.0;
                this.m_min = 0.0;
            } else {
                this.m_max = srcTail.getMax();
                this.m_min = srcTail.getMin();
            }
            this.m_paintSrcList = srcTail;
        } else if (this.m_srcList instanceof IndexLine) {
            IndexLine src = (IndexLine)this.m_srcList;
            IndexLine srcTail = src.getTailLine(((IndexObject)idx).getTag());
            if (this.m_srcList.getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                this.m_max = 100.0;
                this.m_min = 0.0;
            } else {
                this.m_max = srcTail.getMax().getValue();
                this.m_min = srcTail.getMin().getValue();
            }
            this.m_paintSrcList = srcTail;
        } else {
            this.m_max = 0.0;
            this.m_min = 0.0;
            this.m_paintSrcList = this.m_srcList;
        }
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean equals(Object p_other) {
        if (!(p_other instanceof GraphLayer)) {
            return false;
        }
        GraphLayer other = (GraphLayer)p_other;
        return this.m_name.equals(other.getName());
    }

    public String getName() {
        return this.m_name;
    }

    protected double getMax() {
        return this.m_max;
    }

    protected void setMax(double p_max) {
        this.m_max = p_max;
    }

    protected double getMin() {
        return this.m_min;
    }

    protected void setMin(double p_min) {
        this.m_min = p_min;
    }

    public IndexObjectList<?> getPaintSrcList() {
        return this.m_paintSrcList;
    }

    private double getRatio(int p_panelHeight) {
        double indexViewHeight = p_panelHeight * this.m_heightRatio / 100 - (this.m_titleBarTopOffset + this.m_titleBarHeight + this.m_indexTopOffset + this.m_indexBottomOffset);
        double srcLineRange = this.m_max - this.m_min;
        return indexViewHeight / srcLineRange;
    }

    protected void setTop(int p_top) {
        this.m_top = p_top;
    }

    protected int getTop() {
        return this.m_top;
    }

    public int getTitleBarTop() {
        return this.m_top + this.m_titleBarTopOffset;
    }

    public int getIndexTop() {
        return this.getTitleBarTop() + this.m_titleBarHeight + this.m_indexTopOffset;
    }

    protected void setPrevTag(Tag p_prevTag) {
        this.m_prevTag = p_prevTag;
    }

    protected Tag getPrevTag() {
        return this.m_prevTag;
    }

    protected int calcY(double p_value, int p_panelHeight) {
        return (int)((this.getMax() - p_value) * this.getRatio(p_panelHeight)) + this.getIndexTop();
    }

    protected int calcYDistance(double p_distance, int p_panelHeight) {
        return (int)(p_distance * this.getRatio(p_panelHeight));
    }

    public int getIndexScale() {
        return this.m_indexScale;
    }

    public int getLayerNo() {
        return this.m_layerNo;
    }

    public int getTitleBarHeight() {
        return this.m_titleBarHeight;
    }

    public void setTitleBarHeight(int p_titleBarHeight) {
        this.m_titleBarHeight = p_titleBarHeight;
    }

    protected int getTitleBarTopOffset() {
        return this.m_titleBarTopOffset;
    }

    protected int getIndexTopOffset() {
        return this.m_indexTopOffset;
    }

    protected void setIndexTopOffset(int p_indexTopOffset) {
        this.m_indexTopOffset = p_indexTopOffset;
    }

    public Color getForeColor() {
        return this.m_foreColor;
    }

    public void setForeColor(Color p_foreColor) {
        this.m_foreColor = p_foreColor;
    }

    public boolean isStatusColor() {
        return this.m_statusColor;
    }

    public void setStatusColor(boolean p_statusColor) {
        this.m_statusColor = p_statusColor;
    }

    protected int getHeightRatio() {
        return this.m_heightRatio;
    }

    protected void setHeightRatio(int p_heightRatio) {
        this.m_heightRatio = p_heightRatio;
    }

    protected GraphRuler getRuler() {
        return this.m_ruler;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String p_title) {
        this.m_title = p_title;
    }

    public boolean isSyncRuler() {
        return this.m_syncRuler;
    }

    public void setSyncRuler(boolean p_syncRuler) {
        this.m_syncRuler = p_syncRuler;
    }

    protected int getDivCount() {
        return this.m_divCount;
    }

    public boolean isMainLayer() {
        return this.m_mainLayer;
    }
}

