/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.ui.graph;

import java.util.ArrayList;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.ui.graph.GraphException;
import jp.robotbrain.ui.graph.GraphLayer;
import jp.robotbrain.ui.graph.GraphPanel;

public class GraphLayerList
implements Cloneable {
    private final GraphPanel m_parent;
    private int m_maxLayerNo;
    private ArrayList<GraphLayer> m_graphLayerList;

    public GraphLayerList(GraphPanel p_parent) {
        this.m_parent = p_parent;
        this.m_maxLayerNo = -1;
        this.m_graphLayerList = new ArrayList();
    }

    public GraphLayerList clone() {
        GraphLayerList returnValue = new GraphLayerList(this.m_parent);
        returnValue.m_maxLayerNo = this.m_maxLayerNo;
        returnValue.m_graphLayerList = new ArrayList();
        for (GraphLayer graphLayer : this.m_graphLayerList) {
            returnValue.m_graphLayerList.add(graphLayer);
        }
        return returnValue;
    }

    private int getNonZeroLayerMinIndex() throws GraphException {
        int returnValue = -1;
        int i = 0;
        while (i < this.m_graphLayerList.size()) {
            GraphLayer g = this.m_graphLayerList.get(i);
            if (g.getLayerNo() != 0) {
                returnValue = i;
                break;
            }
            ++i;
        }
        return returnValue;
    }

    public GraphLayer add(String p_name, IndexObjectList<?> p_srcList, int p_layerNo, int p_divCount, int p_titleBarTopOffset, int p_indexBottomOffset) throws GraphException {
        GraphLayer returnValue = null;
        if (p_layerNo > this.m_maxLayerNo) {
            this.m_maxLayerNo = p_layerNo;
        }
        if (this.m_graphLayerList.size() <= 0) {
            returnValue = new GraphLayer(this.m_parent, p_name, true, p_srcList, p_layerNo, p_divCount, p_titleBarTopOffset, p_indexBottomOffset);
            this.m_graphLayerList.add(returnValue);
        } else {
            returnValue = new GraphLayer(this.m_parent, p_name, false, p_srcList, p_layerNo, p_divCount, p_titleBarTopOffset, p_indexBottomOffset);
            int nonzero_index = this.getNonZeroLayerMinIndex();
            if (p_layerNo == 0 && nonzero_index != -1) {
                this.m_graphLayerList.add(this.getNonZeroLayerMinIndex(), returnValue);
            } else {
                this.m_graphLayerList.add(returnValue);
            }
        }
        return returnValue;
    }

    protected void syncRuler() {
        if (this.m_maxLayerNo < 0) {
            return;
        }
        int i = 0;
        while (i <= this.m_maxLayerNo) {
            double vmax = Double.MIN_VALUE;
            double vmin = Double.MAX_VALUE;
            for (GraphLayer layer : this.m_graphLayerList) {
                if (layer.getLayerNo() != i || !layer.isSyncRuler()) continue;
                if (vmax < layer.getMax()) {
                    vmax = layer.getMax();
                }
                if (!(vmin > layer.getMin())) continue;
                vmin = layer.getMin();
            }
            for (GraphLayer layer : this.m_graphLayerList) {
                if (layer.getLayerNo() != i || !layer.isSyncRuler()) continue;
                layer.setMax(vmax);
                layer.setMin(vmin);
                layer.initRuler();
                if (layer.isMainLayer()) continue;
                layer.getRuler().setVisible(false);
            }
            ++i;
        }
    }

    public void init() throws GraphException {
        for (GraphLayer layer : this.m_graphLayerList) {
            layer.init();
        }
    }

    protected ArrayList<GraphLayer> getValues() {
        return this.m_graphLayerList;
    }

    public int getMaxLayerNo() {
        return this.m_maxLayerNo;
    }
}

