/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.ui.graph;

import jp.robotbrain.common.UtilDouble;
import jp.robotbrain.common.UtilString;
import jp.robotbrain.ui.graph.GraphLayer;

public class GraphRuler {
    private boolean m_visible = true;
    private final double m_unitMin;
    private final int m_divCount;
    private final int m_scale;
    private final double m_max;
    private final double m_min;
    private final double m_step;

    public GraphRuler(GraphLayer p_parent) {
        double step;
        double max;
        this.m_divCount = p_parent.getDivCount();
        double range = p_parent.getMax() - p_parent.getMin();
        double rangeDiv = range / (double)this.m_divCount;
        this.m_unitMin = this.calcUnitMin(rangeDiv);
        if (this.m_unitMin <= 0.0) {
            this.m_visible = false;
            this.m_step = 0.0;
            this.m_scale = 0;
            this.m_max = 0.0;
            this.m_min = 0.0;
            return;
        }
        double rulerSize = UtilDouble.fix(rangeDiv / this.m_unitMin, 0);
        if (rulerSize < 1.0) {
            rulerSize = 1.0;
        }
        if ((max = UtilDouble.round((step = rulerSize * this.m_unitMin) * UtilDouble.fix(p_parent.getMax() / step, 0), p_parent.getIndexScale())) - step <= p_parent.getMin() && (step = range / 2.0) != 0.0) {
            max = UtilDouble.round(step * UtilDouble.fix(p_parent.getMax() / step, 0), p_parent.getIndexScale());
        }
        if (UtilDouble.getScaleLength(max, p_parent.getIndexScale()) == 0 && UtilDouble.getScaleLength(step, p_parent.getIndexScale()) == 0) {
            this.m_scale = 0;
            if (step < 1.0) {
                step = 1.0;
            }
        } else {
            this.m_scale = p_parent.getIndexScale();
        }
        this.m_max = max;
        this.m_min = p_parent.getMin();
        this.m_step = step;
    }

    protected double calcUnitMin(double p_rangeDiv) {
        String src = UtilDouble.format(p_rangeDiv, 10);
        int intLen = UtilString.getIntLength(src);
        int scaleHeadLen = UtilDouble.getScaleHeadLength(p_rangeDiv);
        if (intLen > 0) {
            return Math.pow(10.0, intLen - 1);
        }
        if (scaleHeadLen > 0) {
            return Math.pow(0.1, scaleHeadLen);
        }
        return 0.0;
    }

    protected boolean isVisible() {
        return this.m_visible;
    }

    protected void setVisible(boolean p_visible) {
        this.m_visible = p_visible;
    }

    public double getUnitMin() {
        return this.m_unitMin;
    }

    public int getDivCount() {
        return this.m_divCount;
    }

    public int getScale() {
        return this.m_scale;
    }

    public double getMax() {
        return this.m_max;
    }

    public double getMin() {
        return this.m_min;
    }

    public double getStep() {
        return this.m_step;
    }
}

