/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jp.robotbrain.common.Location;

public class UtilFile {
    private static Logger m_logger = null;

    private UtilFile() {
    }

    public static Logger getLogger() {
        return m_logger;
    }

    private static void createLogFolder(String p_logLocation) {
        String logFolder = String.valueOf(System.getProperty("user.home")) + p_logLocation.replace("/", Location.FSP);
        if (!UtilFile.isExists(logFolder)) {
            UtilFile.createFolders(logFolder);
        }
    }

    public static synchronized void initLogger(String p_logLocation, String p_fileTitle, String p_logLevel) throws IOException {
        if (m_logger != null) {
            return;
        }
        ByteArrayInputStream configLogStream = null;
        configLogStream = new ByteArrayInputStream(UtilFile.createLogConfig(p_logLocation, p_fileTitle, p_logLevel).getBytes("UTF-8"));
        LogManager.getLogManager().readConfiguration(configLogStream);
        if (configLogStream != null) {
            ((InputStream)configLogStream).close();
            m_logger = Logger.getLogger("jp.robotbrain");
            UtilFile.createLogFolder(p_logLocation);
        }
    }

    private static String createLogConfig(String p_logLocation, String p_fileTitle, String p_logLevel) {
        String returnValue = "handlers=java.util.logging.ConsoleHandler,java.util.logging.FileHandler\n.level=" + p_logLevel + "\n" + "java.util.logging.ConsoleHandler.level=" + p_logLevel + "\n" + "java.util.logging.ConsoleHandler.formatter=java.util.logging.SimpleFormatter\n" + "java.util.logging.FileHandler.level=" + p_logLevel + "\n" + "java.util.logging.FileHandler.pattern=%h" + p_logLocation + p_fileTitle + "_%u\n" + "java.util.logging.FileHandler.formatter=java.util.logging.SimpleFormatter\n" + "java.util.logging.FileHandler.count=10\n";
        return returnValue;
    }

    public static String writeErrorHtml(String p_folderPath, String p_html) {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSSS");
        String filePath = String.valueOf(p_folderPath) + formatter.format(date) + ".html";
        try {
            File dest = new File(filePath);
            FileOutputStream fos = new FileOutputStream(dest, true);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "SJIS");
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write(p_html);
            bw.newLine();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return filePath;
    }

    public static void delete(String p_filePath) {
        File f = new File(p_filePath);
        if (!f.exists()) {
            return;
        }
        if (f.isFile()) {
            f.delete();
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                UtilFile.delete(files[i].getPath());
                ++i;
            }
            f.delete();
        }
    }

    public static void deleteAll(String p_folderPath) {
        File[] files = new File(p_folderPath).listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
    }

    public static boolean copyFolder(String p_src, String p_dest) throws IOException {
        return UtilFile.copyFolder(new File(p_src), new File(p_dest));
    }

    public static boolean copyFile(String p_src, String p_dest) throws IOException {
        return UtilFile.copyFile(new File(p_src), new File(p_dest));
    }

    private static boolean copyFolder(File p_src, File p_dest) throws IOException {
        if (!p_src.exists() || !p_src.isDirectory()) {
            return false;
        }
        p_dest.mkdirs();
        File[] files = p_src.listFiles();
        int i = 0;
        while (files.length > i) {
            if (files[i].isDirectory()) {
                UtilFile.copyFolder(new File(p_src.toString(), files[i].getName()), new File(p_dest.toString(), files[i].getName()));
            } else {
                UtilFile.copyFile(new File(p_src.toString(), files[i].getName()), new File(p_dest.toString(), files[i].getName()));
            }
            ++i;
        }
        return true;
    }

    private static boolean copyFile(File p_src, File p_dest) throws IOException {
        int readByte;
        if (!p_src.exists()) {
            return false;
        }
        byte[] buf = new byte[1024];
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(p_src));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(p_dest));
        while ((readByte = inputStream.read(buf, 0, buf.length)) != -1) {
            outputStream.write(buf, 0, readByte);
        }
        outputStream.close();
        inputStream.close();
        return true;
    }

    public static boolean createFolders(String p_path) {
        File f = new File(p_path);
        if (!f.exists()) {
            return f.mkdirs();
        }
        return true;
    }

    public static boolean isExists(String p_path) {
        File f = new File(p_path);
        return f.exists();
    }

    public static boolean renameFile(String p_src, String p_dest) {
        File src = new File(p_src);
        File dest = new File(p_dest);
        return src.renameTo(dest);
    }

    public static ArrayList<String> listFileNames(String p_path, String p_regex) {
        File f = new File(p_path);
        File[] flist = f.listFiles();
        ArrayList<String> returnValue = new ArrayList<String>();
        if (flist == null) {
            return returnValue;
        }
        File[] fileArray = flist;
        int n = flist.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().matches(p_regex)) {
                returnValue.add(file.getName());
            }
            ++n2;
        }
        return returnValue;
    }

    public static int getLineCount(String p_path) throws IOException {
        LineNumberReader lreader = new LineNumberReader(new FileReader(p_path));
        int returnValue = 0;
        while (lreader.readLine() != null) {
        }
        returnValue = lreader.getLineNumber();
        lreader.close();
        return returnValue;
    }
}

