/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.EnabledOutputSignal;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmIcon;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.SignalStream;
import jp.robotbrain.signal.TypeSignalStream;

@TypeSignalStream
@EnabledDefaultSignal
@EnabledOutputSignal
@GeneDefaultLabelList(values={"border"})
@InputComponentList(values={"@IndexLine"})
public class ExceedBorderSignal
extends SignalStream {
    private static final long serialVersionUID = 1L;
    private final double m_border;

    public ExceedBorderSignal(String p_label, int p_priority, NmSignal p_outputSignal, GeneList p_geneList, String p_borderLabel) throws GeneListException {
        super(p_label, NmIcon.EXCEEDBORDER, p_priority, p_outputSignal);
        this.m_border = p_geneList.getGene(p_borderLabel).getDoubleValue();
        this.getPortList().add("@IndexLine", 1);
    }

    public ExceedBorderSignal(String p_label, int p_priority, NmSignal p_outputSignal, GeneList p_geneList) throws GeneListException {
        super(p_label, NmIcon.EXCEEDBORDER, p_priority, p_outputSignal);
        this.m_border = p_geneList.size() > 0 ? p_geneList.getGene(0).getDoubleValue() : 0.0;
        this.getPortList().add("@IndexLine", 1);
    }

    @Override
    protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
        IndexStreamPort p = this.getPortList().get("@IndexLine");
        if (p == null) {
            throw new IndexStreamException("Null Error");
        }
        if (p.getIndexStream() == null) {
            return null;
        }
        if (p.getIndexStream().getValues() == null) {
            return null;
        }
        if (!(p.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        IndexLine line = (IndexLine)p.getIndexStream().getValues();
        if (line.size() < 1) {
            return null;
        }
        NmSignal returnValue = this.getDefaultSignal();
        if (((IndexPoint)line.getLast()).getValue() > this.m_border) {
            returnValue = this.getOutputSignal();
        }
        return new JudgmentResult(((IndexPoint)line.getLast()).getTag(), returnValue);
    }
}

