/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.Dmi;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.UtilSignal;

public class DmiList
extends IndexObjectList<Dmi> {
    private static final long serialVersionUID = 1L;
    private final int m_ccount;
    private final SimpleLine m_dxLine;
    private final SimpleLine m_diPlusLine;
    private final SimpleLine m_diMinusLine;

    public DmiList(int p_ccount) {
        super(NmViewType.INVISIBLE);
        this.m_ccount = p_ccount;
        this.m_dxLine = new SimpleLine();
        this.m_diPlusLine = new SimpleLine();
        this.m_diMinusLine = new SimpleLine();
    }

    @Override
    public void remove(String p_date) {
        super.remove(p_date);
        this.m_dxLine.remove(p_date);
        this.m_diPlusLine.remove(p_date);
        this.m_diMinusLine.remove(p_date);
    }

    public void addObject(CandleStickList p_src) {
        if (p_src == null) {
            return;
        }
        if (p_src.size() <= this.m_ccount) {
            return;
        }
        Dmi dmi = this.createDMI(p_src);
        CandleStick c = (CandleStick)p_src.getLast();
        this.add(dmi);
        this.m_diPlusLine.addPoint(new IndexPoint(c.getTag(), dmi.getPlusDi()));
        this.m_diMinusLine.addPoint(new IndexPoint(c.getTag(), dmi.getMinusDi()));
        this.m_dxLine.addPoint(new IndexPoint(c.getTag(), dmi.getDx()));
    }

    public IndexLine getDxLine() {
        return this.m_dxLine;
    }

    public IndexLine getDiPlusLine() {
        return this.m_diPlusLine;
    }

    public IndexLine getDiMinusLine() {
        return this.m_diMinusLine;
    }

    private Dmi createDMI(CandleStickList p_src) {
        int begin = p_src.size() - this.m_ccount;
        int end = p_src.size();
        double sumPlusDm = 0.0;
        double sumMinusDm = 0.0;
        double sumTr = 0.0;
        int i = begin;
        while (i < end) {
            CandleStick curCandleStick = (CandleStick)p_src.get(i);
            CandleStick prevCandleStick = (CandleStick)p_src.get(i - 1);
            double plusDm = curCandleStick.getHigh() - prevCandleStick.getHigh();
            double minusDm = prevCandleStick.getLow() - curCandleStick.getLow();
            if (plusDm < 0.0 && minusDm < 0.0) {
                minusDm = 0.0;
                plusDm = 0.0;
            }
            if (plusDm > minusDm) {
                minusDm = 0.0;
            }
            if (plusDm < minusDm) {
                plusDm = 0.0;
            }
            if (plusDm == minusDm) {
                minusDm = 0.0;
                plusDm = 0.0;
            }
            sumPlusDm += plusDm;
            sumMinusDm += minusDm;
            sumTr += UtilSignal.calcTrueRange(prevCandleStick, curCandleStick);
            ++i;
        }
        double p = sumPlusDm / sumTr * 100.0;
        double m = sumMinusDm / sumTr * 100.0;
        CandleStick c = (CandleStick)p_src.getLast();
        return new Dmi(c.getTag(), p, m);
    }
}

