/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.MacdLine;
import jp.robotbrain.signal.NmIcon;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="MacdLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcountShortTermEma", "pcountLongTermEma"})
public class MacdLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final MacdLine m_macdLine;

    public MacdLineStream(String p_label, GeneList p_geneList, String p_pcountShortTermEmaLabel, String p_pcountLongTermEmaLabel) throws GeneListException {
        super(p_label, NmIcon.LINE);
        Gene pcountShortTermEmaGene = p_geneList.getGene(p_pcountShortTermEmaLabel);
        Gene pcountLongTermEmaGene = p_geneList.getGene(p_pcountLongTermEmaLabel);
        int pcountShortTermEma = pcountShortTermEmaGene.getIntValue();
        int pcountLongTermEma = pcountLongTermEmaGene.getIntValue();
        this.m_macdLine = new MacdLine(pcountShortTermEma, pcountLongTermEma);
        int cost = Math.max(pcountShortTermEma, pcountLongTermEma);
        this.getPortList().add("@IndexLine", cost);
    }

    public MacdLineStream(String p_label, GeneList p_geneList) throws GeneListException {
        super(p_label, NmIcon.LINE);
        int pcountShortTermEma = 0;
        int pcountLongTermEma = 0;
        if (p_geneList.size() > 0) {
            Gene pcountShortTermEmaGene = p_geneList.getGene(0);
            Gene pcountLongTermEmaGene = p_geneList.getGene(1);
            pcountShortTermEma = pcountShortTermEmaGene.getIntValue();
            pcountLongTermEma = pcountLongTermEmaGene.getIntValue();
        }
        this.m_macdLine = new MacdLine(pcountShortTermEma, pcountLongTermEma);
        int cost = Math.max(pcountShortTermEma, pcountLongTermEma);
        this.getPortList().add("@IndexLine", cost);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@IndexLine");
        if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_macdLine.addObject((IndexLine)port.getIndexStream().getValues());
        return this.notifyIndexNext();
    }

    @Override
    public MacdLine getValues() {
        return this.m_macdLine;
    }

    public MacdLine getViewValues() {
        return this.m_macdLine;
    }

    @Override
    public void economizeMemory() {
        this.m_macdLine.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_macdLine.setCapacity(capacity);
    }
}

